/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.dceventmanager.utils;

import com.jodexindustries.donatecase.api.event.DCEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Reflection {
    private static void checkJarFile(JarURLConnection connection, String pckgname, ArrayList<Class<? extends DCEvent>> classes) throws IOException {
        JarEntry jarEntry;
        JarFile jarFile = connection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
            String name = jarEntry.getName();
            if (!name.endsWith(".class") || !(name = name.substring(0, name.length() - 6).replace('/', '.')).startsWith(pckgname)) continue;
            try {
                Class<?> clazz = Class.forName(name);
                if (!DCEvent.class.isAssignableFrom(clazz) || clazz == DCEvent.class) continue;
                classes.add(clazz.asSubclass(DCEvent.class));
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList<Class<? extends DCEvent>> getClassesForPackage(ClassLoader cld, String pckgname) throws ClassNotFoundException {
        ArrayList<Class<? extends DCEvent>> classes = new ArrayList<Class<? extends DCEvent>>();
        try {
            URL url;
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(pckgname.replace('.', '/'));
            while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
                try {
                    URLConnection connection = url.openConnection();
                    if (!(connection instanceof JarURLConnection)) throw new ClassNotFoundException(pckgname + " (" + url.getPath() + ") does not appear to be a valid package");
                    Reflection.checkJarFile((JarURLConnection)connection, pckgname, classes);
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ex);
                    return classes;
                }
            }
        }
        catch (NullPointerException ex) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Null pointer exception)", ex);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ex);
        }
    }

    public static Object invokeMethodChain(Object event, String method) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String[] methods;
        for (String methodName : methods = method.split("#")) {
            String methodNameWithoutArgs = methodName.split("\\(")[0];
            String argsString = methodName.contains("(") ? methodName.substring(methodName.indexOf(40) + 1, methodName.indexOf(41)) : "";
            String[] argStrings = argsString.isEmpty() ? new String[]{} : argsString.split(",");
            Object[] args = new Object[argStrings.length];
            Class[] argTypes = new Class[argStrings.length];
            for (int i = 0; i < argStrings.length; ++i) {
                String arg = argStrings[i].trim();
                if (arg.equals("true") || arg.equals("false")) {
                    args[i] = Boolean.parseBoolean(arg);
                    argTypes[i] = Boolean.TYPE;
                    continue;
                }
                try {
                    args[i] = Integer.parseInt(arg);
                    argTypes[i] = Integer.TYPE;
                    continue;
                }
                catch (NumberFormatException e) {
                    args[i] = arg;
                    argTypes[i] = String.class;
                }
            }
            Method m = args.length > 0 ? event.getClass().getMethod(methodNameWithoutArgs, argTypes) : event.getClass().getMethod(methodNameWithoutArgs, new Class[0]);
            m.setAccessible(true);
            event = m.invoke(event, args);
        }
        return event;
    }
}

