/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.dceventmanager.utils;

import com.jodexindustries.dceventmanager.bootstrap.MainAddon;
import com.jodexindustries.dceventmanager.config.ConfigManager;
import com.jodexindustries.dceventmanager.config.PlaceholderConfig;
import com.jodexindustries.dceventmanager.event.DCEventExecutor;
import com.jodexindustries.dceventmanager.utils.PlaceholderGenerator;
import com.jodexindustries.dceventmanager.utils.Reflection;
import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.addon.InternalJavaAddon;
import com.jodexindustries.donatecase.api.event.DCEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import lombok.Generated;
import net.kyori.event.EventSubscriber;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.serialize.SerializationException;

public class Tools {
    public static List<DCEventExecutor> executors = new ArrayList<DCEventExecutor>();
    public final DCAPI api = DCAPI.getInstance();
    public boolean debug = false;
    public final MainAddon main;
    private final ConfigManager configManager;

    public Tools(MainAddon main) {
        this.main = main;
        this.configManager = new ConfigManager(main);
    }

    public void load() {
        this.loadConfig();
        this.debug = this.configManager.getConfig().node(new Object[]{"debug"}).getBoolean();
        this.registerExecutors();
        this.registerEvents();
    }

    public void unload() {
        this.unregisterEvents();
    }

    public void registerExecutors() {
        executors.clear();
        Set<Class<? extends DCEvent>> classes = this.getClasses();
        this.generatePlaceholders(classes);
        for (Class<? extends DCEvent> clazz : classes) {
            DCEventExecutor executor = new DCEventExecutor(clazz, this);
            executors.add(executor);
            if (!this.debug) continue;
            this.main.getLogger().info("Executor for " + clazz.getSimpleName() + " registered");
        }
    }

    public void registerEvents() {
        this.unregisterEvents();
        for (DCEventExecutor executor : executors) {
            this.api.getEventBus().register(executor.clazz, (EventSubscriber)executor);
        }
        this.main.getLogger().info("Registered " + executors.size() + " executors");
    }

    public void unregisterEvents() {
        executors.forEach(executor -> this.api.getEventBus().unregister((EventSubscriber)executor));
    }

    public void loadConfig() {
        try {
            this.configManager.load();
            this.main.getLogger().info("Registered " + this.configManager.getEventConfig().getEvents().size() + " events");
        }
        catch (ConfigurateException e) {
            this.main.getLogger().log(Level.WARNING, "Error with loading configuration", (Throwable)e);
        }
    }

    private void generatePlaceholders(Set<Class<? extends DCEvent>> classes) {
        PlaceholderConfig config = this.configManager.getPlaceholderConfig();
        if (!config.getEventPlaceholders().isEmpty()) {
            return;
        }
        this.main.getLogger().info("Generating player's placeholders for all available events");
        PlaceholderGenerator generator = new PlaceholderGenerator(config, classes);
        try {
            generator.generate();
            config.update();
        }
        catch (ConfigurateException e) {
            this.main.getLogger().log(Level.WARNING, "Error with updating placeholders", (Throwable)e);
        }
    }

    private Set<Class<? extends DCEvent>> getClasses() {
        HashSet<Class<? extends DCEvent>> classes = new HashSet<Class<? extends DCEvent>>();
        try {
            List packages = this.configManager.getConfig().node(new Object[]{"packages"}).getList(String.class);
            if (packages != null) {
                for (String pkg : packages) {
                    classes.addAll(Reflection.getClassesForPackage(this.getClass().getClassLoader().getParent(), pkg));
                    for (InternalJavaAddon addon : this.api.getAddonManager().getMap().values()) {
                        classes.addAll(Reflection.getClassesForPackage((ClassLoader)addon.getUrlClassLoader(), pkg));
                    }
                }
            }
        }
        catch (ClassNotFoundException | SerializationException e) {
            throw new RuntimeException(e);
        }
        return classes;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

