/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.dchistoryeditor;

import com.jodexindustries.dchistoryeditor.MainAddon;
import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.database.DatabaseStatus;
import com.jodexindustries.donatecase.api.data.subcommand.SubCommandExecutor;
import com.jodexindustries.donatecase.api.data.subcommand.SubCommandTabCompleter;
import com.jodexindustries.donatecase.api.database.CaseDatabase;
import com.jodexindustries.donatecase.api.platform.DCCommandSender;
import com.jodexindustries.donatecase.api.tools.DCTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class MainCommand
implements SubCommandExecutor,
SubCommandTabCompleter {
    private final CaseDatabase database;
    private final MainAddon addon;
    private static final List<String> params = new ArrayList<String>();

    public MainCommand(MainAddon addon) {
        this.addon = addon;
        this.database = addon.api.getDatabase();
    }

    public boolean execute(@NotNull DCCommandSender sender, @NotNull String label, @NotNull String[] args) {
        this.addon.api.getPlatform().getScheduler().async((Addon)this.addon, () -> {
            if (args.length < 3) {
                sender.sendMessage(DCTools.rc((String)"&c/dc historyeditor (remove/set) (casetype) (index/all) [param] [value]"));
                return;
            }
            String action = args[0].toLowerCase();
            String caseType = args[1];
            Optional optional = this.addon.api.getCaseManager().getByType(caseType);
            if (!optional.isPresent()) {
                sender.sendMessage(DCTools.rc((String)("&cCase with type: '" + caseType + "' not found!")));
                return;
            }
            CaseDefinition definition = (CaseDefinition)optional.get();
            switch (action) {
                case "remove": {
                    this.handleRemove(sender, definition, args[2]);
                    return;
                }
                case "set": {
                    this.handleSet(sender, definition, args);
                    return;
                }
            }
            sender.sendMessage(DCTools.rc((String)"&c/dc historyeditor (remove/set) (casetype) (index) [param] [value]"));
        }, 0L);
        return true;
    }

    public List<String> getTabCompletions(@NotNull DCCommandSender sender, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            list.add("remove");
            list.add("set");
        }
        if (args.length == 2) {
            list.addAll(this.addon.api.getCaseManager().definitions().stream().map(definition -> definition.settings().type()).collect(Collectors.toList()));
        }
        if (args.length == 3) {
            list.add("all");
            IntStream.rangeClosed(0, 10).mapToObj(String::valueOf).forEach(list::add);
        }
        if (args.length == 4 && args[0].equals("set")) {
            list.addAll(params);
        }
        return list;
    }

    private void handleRemove(DCCommandSender sender, CaseDefinition definition, String arg) {
        if (arg.equalsIgnoreCase("all")) {
            this.database.removeHistoryData(definition.settings().type()).thenAccept(status -> this.removeInform(sender, (DatabaseStatus)status));
        } else {
            int index = this.getIndex(sender, arg, definition.settings().historyDataSize());
            if (index == -1) {
                return;
            }
            this.database.removeHistoryData(definition.settings().type(), index).thenAccept(status -> this.removeInform(sender, (DatabaseStatus)status));
        }
    }

    private void handleSet(DCCommandSender sender, CaseDefinition definition, String[] args) {
        int index = this.getIndex(sender, args[2], definition.settings().historyDataSize());
        if (index == -1) {
            return;
        }
        if (args.length < 5) {
            sender.sendMessage(DCTools.rc((String)"&c/dc historyeditor set (casetype) (index) (value) (param)"));
            return;
        }
        String param = args[3].toLowerCase();
        String value = args[4];
        if (!params.contains(param)) {
            sender.sendMessage(DCTools.rc((String)("&cParam " + param + " is not found!")));
            return;
        }
        CaseData.History tempHistory = this.getHistoryData(definition.settings().type(), index);
        CaseData.History history = tempHistory == null ? new CaseData.History(null, definition.settings().type(), null, (long)index, null, null) : tempHistory;
        switch (param) {
            case "item": {
                history.item(value);
                break;
            }
            case "playername": {
                history.playerName(value);
                break;
            }
            case "time": {
                history.time(Long.parseLong(value));
                break;
            }
            case "group": {
                history.group(value);
                break;
            }
            case "action": {
                history.action(value);
            }
        }
        this.database.setHistoryData(definition.settings().type(), index, history).thenAccept(status -> {
            if (status == DatabaseStatus.COMPLETE) {
                sender.sendMessage(DCTools.rc((String)"&aHistory data updated!"));
            } else {
                sender.sendMessage(DCTools.rc((String)"&cError with history data updating!"));
            }
        });
    }

    private CaseData.History getHistoryData(String caseType, int index) {
        List histories = (List)this.database.getHistoryData(caseType).join();
        return (CaseData.History)histories.get(index);
    }

    private void removeInform(DCCommandSender sender, DatabaseStatus status) {
        sender.sendMessage(status == DatabaseStatus.COMPLETE ? DCTools.rc((String)"&aHistory data removed!") : DCTools.rc((String)"&cError with history data removing!"));
    }

    private int getIndex(DCCommandSender sender, String string, int maxSize) {
        int index = this.parseInt(string);
        if (index <= -1 || index >= maxSize) {
            sender.sendMessage(DCTools.rc((String)"&cNumber format exception!"));
            return -1;
        }
        return index;
    }

    private int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    static {
        params.add("item");
        params.add("playername");
        params.add("time");
        params.add("group");
        params.add("action");
    }
}

