/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.dcphysicalkey.listener;

import com.jodexindustries.dcphysicalkey.bootstrap.MainAddon;
import com.jodexindustries.donatecase.api.event.Subscriber;
import com.jodexindustries.donatecase.api.event.player.PreOpenCaseEvent;
import com.jodexindustries.donatecase.api.event.plugin.DonateCaseReloadEvent;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import net.kyori.event.method.annotation.Subscribe;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class EventListener
implements Listener,
Subscriber {
    private final MainAddon addon;

    public EventListener(MainAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onReload(DonateCaseReloadEvent e) {
        if (e.type() == DonateCaseReloadEvent.Type.CONFIG) {
            this.addon.getConfig().reloadConfig();
        }
    }

    @Subscribe
    public void onCaseInteract(PreOpenCaseEvent event) {
        DCPlayer dcPlayer = event.player();
        Player player = (Player)dcPlayer.getHandler();
        for (ItemStack item : player.getInventory().getContents()) {
            PersistentDataContainer container;
            ItemMeta meta;
            if (item == null || !item.hasItemMeta() || (meta = item.getItemMeta()) == null || !(container = meta.getPersistentDataContainer()).has(MainAddon.NAMESPACED_KEY, PersistentDataType.STRING)) continue;
            String caseType = (String)container.get(MainAddon.NAMESPACED_KEY, PersistentDataType.STRING);
            if (!event.definition().settings().type().equals(caseType)) continue;
            event.ignoreKeys(true);
            item.setAmount(item.getAmount() - 1);
            break;
        }
    }

    @EventHandler
    public void onCaseKeyPlace(BlockPlaceEvent event) {
        ItemStack item = event.getItemInHand();
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            PersistentDataContainer container = meta.getPersistentDataContainer();
            if (container.has(MainAddon.NAMESPACED_KEY, PersistentDataType.STRING)) {
                event.setCancelled(true);
            }
        }
    }
}

