/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.dcprizepreview.gui;

import com.jodexindustries.dcprizepreview.bootstrap.MainAddon;
import com.jodexindustries.dcprizepreview.config.CasePreview;
import com.jodexindustries.dcprizepreview.gui.PreviewGUI;
import com.jodexindustries.donatecase.api.event.Subscriber;
import com.jodexindustries.donatecase.api.event.player.CaseInteractEvent;
import com.jodexindustries.donatecase.api.event.plugin.DonateCaseReloadEvent;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.kyori.event.method.annotation.Subscribe;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;

public class EventListener
implements Subscriber,
Listener {
    private final HashSet<UUID> players = new HashSet();
    private final MainAddon addon;

    public EventListener(MainAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onReload(DonateCaseReloadEvent e) {
        if (e.type() == DonateCaseReloadEvent.Type.CONFIG) {
            this.addon.load(true);
        }
    }

    @Subscribe
    public void onInteract(CaseInteractEvent e) {
        if (e.action() == CaseInteractEvent.Action.LEFT) {
            String caseType = e.caseInfo().type();
            CasePreview casePreview = this.addon.config.previewMap.get(caseType);
            if (casePreview == null) {
                return;
            }
            DCPlayer player = e.player();
            switch (casePreview.type()) {
                case AUTO: {
                    Optional optional = this.addon.api.getCaseManager().getByType(caseType);
                    optional.ifPresent(definition -> {
                        Inventory inventory = PreviewGUI.loadGUI(definition);
                        player.openInventory((Object)inventory);
                        this.players.add(player.getUniqueId());
                    });
                    break;
                }
                case COMMAND: {
                    if (!(player instanceof Player)) break;
                    ((Player)player).chat(casePreview.command());
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (this.players.contains(e.getWhoClicked().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        this.players.remove(e.getPlayer().getUniqueId());
    }
}

