/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.dcprizepreview.gui;

import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMaterial;
import com.jodexindustries.donatecase.api.tools.DCTools;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PreviewGUI {
    @NotNull
    public static Inventory loadGUI(@NotNull CaseDefinition definition) {
        Collection items = definition.items().items().values();
        Inventory inventory = Bukkit.createInventory(null, (int)PreviewGUI.getSize(items.size()), (String)DCTools.rc((String)definition.defaultMenu().title()));
        items = items.stream().sorted(Comparator.comparingInt(CaseItem::index)).collect(Collectors.toList());
        for (CaseItem item : items) {
            CaseMaterial material = item.material();
            material.updateMeta();
            inventory.addItem(new ItemStack[]{(ItemStack)material.itemStack()});
        }
        return inventory;
    }

    private static int getSize(int items) {
        if (items > 45) {
            return 54;
        }
        if (items > 36) {
            return 45;
        }
        if (items > 27) {
            return 36;
        }
        if (items > 18) {
            return 27;
        }
        if (items > 9) {
            return 18;
        }
        return 9;
    }
}

