/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.dcwebhook.events;

import com.jodexindustries.dcwebhook.bootstrap.MainAddon;
import com.jodexindustries.dcwebhook.config.DiscordWebhook;
import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.event.Subscriber;
import com.jodexindustries.donatecase.api.event.animation.AnimationEndEvent;
import com.jodexindustries.donatecase.api.event.plugin.DonateCaseReloadEvent;
import java.io.IOException;
import java.util.logging.Level;
import net.kyori.event.method.annotation.PostOrder;
import net.kyori.event.method.annotation.Subscribe;

public class EventListener
implements Subscriber {
    private final MainAddon addon;

    public EventListener(MainAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    @PostOrder(value=100)
    public void onReload(DonateCaseReloadEvent e) {
        if (e.type() == DonateCaseReloadEvent.Type.CONFIG) {
            this.addon.config.load();
        }
    }

    @Subscribe
    @PostOrder(value=100)
    public void onAnimationEnd(AnimationEndEvent e) {
        this.addon.api.getPlatform().getScheduler().async((Addon)this.addon, () -> {
            try {
                DiscordWebhook webhook = this.addon.config.getWebhook();
                if (webhook != null) {
                    webhook.execute(e);
                }
            }
            catch (IOException ex) {
                this.addon.getLogger().log(Level.WARNING, "Error with webhook sending: ", (Throwable)ex);
            }
        }, 0L);
    }
}

