/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.caching;

import com.jodexindustries.donatecase.api.caching.CacheEntry;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class SimpleCache<K, V> {
    private final Map<K, CacheEntry<V>> cache = new HashMap<K, CacheEntry<V>>();
    private long maxAge;

    public SimpleCache(long maxAge) {
        this.maxAge = maxAge;
    }

    @Nullable
    public V get(K key) {
        CacheEntry<V> entry = this.cache.get(key);
        if (entry != null && this.isValid(entry)) {
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public V getPrevious(K key) {
        CacheEntry<V> entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public void put(K key, V value) {
        this.cache.put(key, new CacheEntry<V>(value, System.currentTimeMillis()));
    }

    private boolean isValid(CacheEntry<V> entry) {
        return System.currentTimeMillis() - entry.getTimestamp() <= this.maxAge * 50L;
    }

    public void clear() {
        this.cache.clear();
    }

    @Generated
    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }
}

