/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.data.casedata;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.jodexindustries.donatecase.api.data.casedata.CaseDataItem;
import com.jodexindustries.donatecase.api.data.casedata.OpenType;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseGui;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItems;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMenu;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseSettings;
import com.jodexindustries.donatecase.api.tools.ProbabilityCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Required;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public class CaseData
implements Cloneable {
    private transient String caseType;
    @Deprecated
    @Setting(value="DisplayName")
    private String caseDisplayName;
    @Deprecated
    @Setting(value="Animation")
    @Required
    private String animation;
    @Deprecated
    @Setting(value="Items")
    private Map<String, CaseDataItem> items;
    @Deprecated
    @Setting(value="Hologram")
    private Hologram hologram;
    @Deprecated
    @Setting(value="LevelGroups")
    private Map<String, Integer> levelGroups;
    @Deprecated
    @Setting(value="Gui")
    private CaseGui caseGui;
    @Deprecated
    @Setting(value="NoKeyActions")
    private List<String> noKeyActions;
    @Deprecated
    @Setting(value="OpenType")
    private OpenType openType = OpenType.GUI;
    @Deprecated
    @Setting(value="AnimationSettings")
    private ConfigurationNode animationSettings;
    @Deprecated
    @Setting(value="CooldownBeforeAnimation")
    private int cooldownBeforeStart;
    @Deprecated
    @Setting(value="HistoryDataSize")
    private int historyDataSize;

    @Deprecated
    @Nullable
    public CaseDataItem getItem(String name) {
        return this.items.getOrDefault(name, null);
    }

    @Deprecated
    public CaseDataItem getRandomItem() {
        ProbabilityCollection<CaseDataItem> collection = new ProbabilityCollection<CaseDataItem>();
        for (CaseDataItem item : this.items.values()) {
            double chance = item.chance();
            if (!(chance > 0.0)) continue;
            collection.add(item, chance);
        }
        return (CaseDataItem)collection.get();
    }

    @Deprecated
    public boolean hasRealItems() {
        return this.items.values().stream().anyMatch(item -> item.chance() > 0.0);
    }

    @Deprecated
    public static CaseData fromDefinition(CaseDefinition definition) {
        CaseSettings settings = definition.settings();
        CaseData caseData = new CaseData();
        caseData.caseType = settings.type();
        caseData.openType = settings.openType();
        caseData.animation = settings.animation();
        caseData.animationSettings = settings.animationSettings();
        caseData.levelGroups = settings.levelGroups().map();
        caseData.noKeyActions = settings.noKeyActions();
        caseData.caseDisplayName = settings.displayName();
        caseData.cooldownBeforeStart = settings.cooldownBeforeAnimation();
        caseData.historyDataSize = settings.historyDataSize();
        caseData.hologram = Hologram.fromDefinition(settings.hologram());
        caseData.caseGui = CaseGui.fromMenu(definition.defaultMenu());
        caseData.items = CaseData.fromDefinition(definition.items());
        return caseData;
    }

    @Deprecated
    public static CaseDefinition toDefinition(CaseData data) {
        CaseSettings.Hologram hologram = new CaseSettings.Hologram(data.hologram.node, data.hologram.enabled, data.hologram.height, data.hologram.range, data.hologram.messages);
        CaseSettings settings = new CaseSettings(data.caseType, "default_menu", data.animation, hologram, new CaseSettings.LevelGroups(data.levelGroups), data.noKeyActions, data.openType, data.animationSettings, data.cooldownBeforeStart, data.historyDataSize, data.caseDisplayName);
        CaseItems items = CaseData.toDefinition(data.items);
        ArrayList<CaseMenu> menus = new ArrayList<CaseMenu>();
        if (data.caseGui != null) {
            menus.add(CaseGui.toMenu(data.caseGui));
        }
        return new CaseDefinition(settings, items, menus);
    }

    @Deprecated
    private static Map<String, CaseDataItem> fromDefinition(CaseItems items) {
        HashMap<String, CaseDataItem> old = new HashMap<String, CaseDataItem>();
        for (Map.Entry<String, CaseItem> entry : items.items().entrySet()) {
            old.put(entry.getKey(), CaseDataItem.fromItem(entry.getValue()));
        }
        return old;
    }

    @Deprecated
    private static CaseItems toDefinition(Map<String, CaseDataItem> oldItems) {
        HashMap<String, CaseItem> items = new HashMap<String, CaseItem>();
        for (Map.Entry<String, CaseDataItem> entry : oldItems.entrySet()) {
            items.put(entry.getKey(), CaseDataItem.toItem(entry.getValue()));
        }
        return new CaseItems(items);
    }

    @Deprecated
    public CaseData clone() {
        try {
            CaseData clonedCaseData = (CaseData)super.clone();
            if (this.items != null) {
                clonedCaseData.items = CaseData.cloneItemsMap(this.items);
            }
            if (this.caseGui != null) {
                clonedCaseData.caseGui = this.caseGui.clone();
            }
            return clonedCaseData;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    public String toString() {
        return "CaseData{caseType='" + this.caseType + '\'' + ", caseDisplayName='" + this.caseDisplayName + '\'' + ", animation='" + this.animation + '\'' + ", items=" + this.items + ", hologram=" + this.hologram + ", levelGroups=" + this.levelGroups + ", caseGui=" + this.caseGui + ", noKeyActions=" + this.noKeyActions + ", openType=" + (Object)((Object)this.openType) + ", animationSettings=" + this.animationSettings + '}';
    }

    @Deprecated
    protected static Map<String, CaseDataItem> cloneItemsMap(Map<String, CaseDataItem> originalMap) {
        HashMap<String, CaseDataItem> clonedMap = new HashMap<String, CaseDataItem>();
        for (Map.Entry<String, CaseDataItem> entry : originalMap.entrySet()) {
            clonedMap.put(entry.getKey(), entry.getValue().clone());
        }
        return clonedMap;
    }

    @Generated
    public String caseType() {
        return this.caseType;
    }

    @Deprecated
    @Generated
    public String caseDisplayName() {
        return this.caseDisplayName;
    }

    @Deprecated
    @Generated
    public String animation() {
        return this.animation;
    }

    @Deprecated
    @Generated
    public Map<String, CaseDataItem> items() {
        return this.items;
    }

    @Deprecated
    @Generated
    public Hologram hologram() {
        return this.hologram;
    }

    @Deprecated
    @Generated
    public Map<String, Integer> levelGroups() {
        return this.levelGroups;
    }

    @Deprecated
    @Generated
    public CaseGui caseGui() {
        return this.caseGui;
    }

    @Deprecated
    @Generated
    public List<String> noKeyActions() {
        return this.noKeyActions;
    }

    @Deprecated
    @Generated
    public OpenType openType() {
        return this.openType;
    }

    @Deprecated
    @Generated
    public ConfigurationNode animationSettings() {
        return this.animationSettings;
    }

    @Deprecated
    @Generated
    public int cooldownBeforeStart() {
        return this.cooldownBeforeStart;
    }

    @Deprecated
    @Generated
    public int historyDataSize() {
        return this.historyDataSize;
    }

    @Generated
    public CaseData caseType(String caseType) {
        this.caseType = caseType;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData caseDisplayName(String caseDisplayName) {
        this.caseDisplayName = caseDisplayName;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData animation(String animation) {
        this.animation = animation;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData items(Map<String, CaseDataItem> items) {
        this.items = items;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData hologram(Hologram hologram) {
        this.hologram = hologram;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData levelGroups(Map<String, Integer> levelGroups) {
        this.levelGroups = levelGroups;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData caseGui(CaseGui caseGui) {
        this.caseGui = caseGui;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData noKeyActions(List<String> noKeyActions) {
        this.noKeyActions = noKeyActions;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData openType(OpenType openType) {
        this.openType = openType;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData animationSettings(ConfigurationNode animationSettings) {
        this.animationSettings = animationSettings;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData cooldownBeforeStart(int cooldownBeforeStart) {
        this.cooldownBeforeStart = cooldownBeforeStart;
        return this;
    }

    @Deprecated
    @Generated
    public CaseData historyDataSize(int historyDataSize) {
        this.historyDataSize = historyDataSize;
        return this;
    }

    @ConfigSerializable
    @Deprecated
    public static class Hologram {
        @Deprecated
        @Setting(nodeFromParent=true)
        private ConfigurationNode node;
        @Deprecated
        @Setting(value="Toggle")
        private boolean enabled;
        @Deprecated
        @Setting(value="Height")
        private double height;
        @Deprecated
        @Setting(value="Range")
        private int range;
        @Deprecated
        @Setting(value="Message")
        private List<String> messages;

        @Deprecated
        public static CaseSettings.Hologram toDefinition(Hologram hologram) {
            return new CaseSettings.Hologram(hologram.node, hologram.enabled, hologram.height, hologram.range, hologram.messages);
        }

        @Deprecated
        public static Hologram fromDefinition(CaseSettings.Hologram hologram) {
            Hologram old = new Hologram();
            old.enabled = hologram.enabled();
            old.range = hologram.range();
            old.messages = hologram.message();
            old.height = hologram.height();
            old.node = hologram.node();
            return old;
        }

        @Deprecated
        @Generated
        public ConfigurationNode node() {
            return this.node;
        }

        @Deprecated
        @Generated
        public boolean enabled() {
            return this.enabled;
        }

        @Deprecated
        @Generated
        public double height() {
            return this.height;
        }

        @Deprecated
        @Generated
        public int range() {
            return this.range;
        }

        @Deprecated
        @Generated
        public List<String> messages() {
            return this.messages;
        }
    }

    @DatabaseTable(tableName="history_data")
    public static class History {
        @DatabaseField(columnName="id")
        @Deprecated
        private int id;
        @DatabaseField(columnName="item")
        private String item;
        @DatabaseField(columnName="player_name")
        private String playerName;
        @DatabaseField(columnName="time")
        private long time;
        @DatabaseField(columnName="group")
        private String group;
        @DatabaseField(columnName="case_type")
        private String caseType;
        @DatabaseField(columnName="action")
        private String action;

        public History(String item, String caseType, String playerName, long time, String group, String action) {
            this.item = item;
            this.playerName = playerName;
            this.time = time;
            this.group = group;
            this.caseType = caseType;
            this.action = action;
        }

        public History() {
        }

        public String toString() {
            return "History{item='" + this.item + '\'' + ", playerName='" + this.playerName + '\'' + ", time=" + this.time + ", group='" + this.group + '\'' + ", caseType='" + this.caseType + '\'' + ", action='" + this.action + '\'' + '}';
        }

        public History clone() {
            try {
                return (History)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Deprecated
        @Generated
        public int id() {
            return this.id;
        }

        @Generated
        public String item() {
            return this.item;
        }

        @Generated
        public String playerName() {
            return this.playerName;
        }

        @Generated
        public long time() {
            return this.time;
        }

        @Generated
        public String group() {
            return this.group;
        }

        @Generated
        public String caseType() {
            return this.caseType;
        }

        @Generated
        public String action() {
            return this.action;
        }

        @Deprecated
        @Generated
        public void id(int id) {
            this.id = id;
        }

        @Generated
        public void item(String item) {
            this.item = item;
        }

        @Generated
        public void playerName(String playerName) {
            this.playerName = playerName;
        }

        @Generated
        public void time(long time) {
            this.time = time;
        }

        @Generated
        public void group(String group) {
            this.group = group;
        }

        @Generated
        public void caseType(String caseType) {
            this.caseType = caseType;
        }

        @Generated
        public void action(String action) {
            this.action = action;
        }
    }
}

