/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.data.casedefinition;

import com.jodexindustries.donatecase.api.data.casedefinition.CaseItems;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMenu;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseSettings;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseDefinition
implements Cloneable {
    @NotNull
    private CaseSettings settings;
    @NotNull
    private CaseItems items;
    @NotNull
    private List<CaseMenu> menus;
    @NotNull
    private CaseMenu defaultMenu;

    public CaseDefinition(@NotNull CaseSettings settings, @NotNull CaseItems items, @NotNull List<CaseMenu> menus) {
        this(settings, items, menus, null);
    }

    public CaseDefinition(@NotNull CaseSettings settings, @NotNull CaseItems items, @NotNull List<CaseMenu> menus, @Nullable CaseMenu defaultMenu) {
        this.settings = settings;
        this.items = items;
        this.menus = menus;
        this.defaultMenu = defaultMenu == null ? this.getMenuById(settings.defaultMenu()).orElseGet(() -> (CaseMenu)menus.get(0)) : defaultMenu;
    }

    @NotNull
    public List<CaseMenu> menus() {
        return Collections.unmodifiableList(this.menus);
    }

    @NotNull
    public Optional<CaseMenu> getMenuById(@NotNull String id) {
        return this.menus.stream().filter(menu -> menu.id().equals(id)).findFirst();
    }

    public CaseDefinition clone() {
        try {
            CaseDefinition clone = (CaseDefinition)super.clone();
            clone.settings = this.settings.clone();
            clone.items = this.items.clone();
            clone.menus = this.menus.stream().map(CaseMenu::clone).collect(Collectors.toList());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @NotNull
    @Generated
    public CaseSettings settings() {
        return this.settings;
    }

    @NotNull
    @Generated
    public CaseItems items() {
        return this.items;
    }

    @NotNull
    @Generated
    public CaseMenu defaultMenu() {
        return this.defaultMenu;
    }

    @Generated
    public void defaultMenu(@NotNull CaseMenu defaultMenu) {
        if (defaultMenu == null) {
            throw new NullPointerException("defaultMenu is marked non-null but is null");
        }
        this.defaultMenu = defaultMenu;
    }
}

