/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.data.casedefinition;

import com.jodexindustries.donatecase.api.data.casedata.GiveType;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMaterial;
import com.jodexindustries.donatecase.api.tools.ProbabilityCollection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class CaseItem
implements Cloneable {
    private String name;
    private String group;
    private double chance;
    private int index;
    private CaseMaterial material;
    private GiveType giveType;
    private List<String> actions;
    private List<String> alternativeActions;
    private Map<String, RandomAction> randomActions;

    public CaseItem(String name, String group, double chance, int index, CaseMaterial material, GiveType giveType, List<String> actions, List<String> alternativeActions, Map<String, RandomAction> randomActions) {
        this.name = name;
        this.group = group;
        this.chance = chance;
        this.index = index;
        this.material = material;
        this.giveType = giveType;
        this.actions = actions;
        this.alternativeActions = alternativeActions;
        this.randomActions = randomActions;
    }

    public RandomAction getRandomAction() {
        ProbabilityCollection<RandomAction> collection = new ProbabilityCollection<RandomAction>();
        for (RandomAction randomAction : this.randomActions().values()) {
            double chance = randomAction.chance();
            if (!(chance > 0.0)) continue;
            collection.add(randomAction, chance);
        }
        return (RandomAction)collection.get();
    }

    public List<String> getActionsBasedOnChoice(RandomAction randomAction, boolean alternative) {
        if (randomAction != null) {
            return randomAction.actions();
        }
        return alternative ? this.alternativeActions() : this.actions();
    }

    public CaseItem clone() {
        try {
            CaseItem clone = (CaseItem)super.clone();
            clone.randomActions = this.randomActions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((RandomAction)entry.getValue()).clone(), (a, b) -> b));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public String group() {
        return this.group;
    }

    @Generated
    public double chance() {
        return this.chance;
    }

    @Generated
    public int index() {
        return this.index;
    }

    @Generated
    public CaseMaterial material() {
        return this.material;
    }

    @Generated
    public GiveType giveType() {
        return this.giveType;
    }

    @Generated
    public List<String> actions() {
        return this.actions;
    }

    @Generated
    public List<String> alternativeActions() {
        return this.alternativeActions;
    }

    @Generated
    public Map<String, RandomAction> randomActions() {
        return this.randomActions;
    }

    @Generated
    public void name(String name) {
        this.name = name;
    }

    @Generated
    public void group(String group) {
        this.group = group;
    }

    @Generated
    public void chance(double chance) {
        this.chance = chance;
    }

    @Generated
    public void index(int index) {
        this.index = index;
    }

    @Generated
    public void material(CaseMaterial material) {
        this.material = material;
    }

    @Generated
    public void giveType(GiveType giveType) {
        this.giveType = giveType;
    }

    @Generated
    public void actions(List<String> actions) {
        this.actions = actions;
    }

    @Generated
    public void alternativeActions(List<String> alternativeActions) {
        this.alternativeActions = alternativeActions;
    }

    @Generated
    public void randomActions(Map<String, RandomAction> randomActions) {
        this.randomActions = randomActions;
    }

    public static class RandomAction
    implements Cloneable {
        private String name;
        private double chance;
        private List<String> actions;
        private String displayName;

        public RandomAction(String name, double chance, List<String> actions, String displayName) {
            this.name = name;
            this.chance = chance;
            this.actions = actions;
            this.displayName = displayName;
        }

        public RandomAction clone() {
            try {
                return (RandomAction)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        @Generated
        public String name() {
            return this.name;
        }

        @Generated
        public double chance() {
            return this.chance;
        }

        @Generated
        public List<String> actions() {
            return this.actions;
        }

        @Generated
        public String displayName() {
            return this.displayName;
        }

        @Generated
        public void name(String name) {
            this.name = name;
        }

        @Generated
        public void chance(double chance) {
            this.chance = chance;
        }

        @Generated
        public void actions(List<String> actions) {
            this.actions = actions;
        }

        @Generated
        public void displayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

