/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.data.casedefinition;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.casedata.MetaUpdater;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.tools.ProbabilityCollection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseItems
implements Cloneable {
    private Map<String, CaseItem> items;

    public CaseItems(Map<String, CaseItem> items) {
        this.items = items;
    }

    @Nullable
    public CaseItem getItem(@NotNull String name) {
        return this.items.get(name);
    }

    public CaseItem getRandomItem() {
        ProbabilityCollection<CaseItem> collection = new ProbabilityCollection<CaseItem>();
        for (CaseItem item : this.items.values()) {
            double chance = item.chance();
            if (!(chance > 0.0)) continue;
            collection.add(item, chance);
        }
        return (CaseItem)collection.get();
    }

    public void items(Map<String, CaseItem> items) {
        this.items = items;
    }

    public Map<String, CaseItem> items() {
        return Collections.unmodifiableMap(this.items);
    }

    public void updateItemsMeta() {
        this.updateItemsMeta(DCAPI.getInstance().getPlatform().getMetaUpdater());
    }

    public void updateItemsMeta(MetaUpdater metaUpdater) {
        this.items.values().forEach(value -> value.material().updateMeta(metaUpdater));
    }

    public boolean hasRealItems() {
        return this.items.values().stream().anyMatch(item -> item.chance() > 0.0);
    }

    public CaseItems clone() {
        try {
            CaseItems clone = (CaseItems)super.clone();
            clone.items = this.items.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((CaseItem)entry.getValue()).clone(), (a, b) -> b));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

