/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.data.casedefinition;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.casedata.MetaUpdater;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class CaseMaterial
implements MetaUpdater,
Cloneable {
    private String id;
    private String displayName;
    private boolean enchanted;
    private List<String> lore;
    private int modelData;
    private String[] rgb;
    private Object itemStack;

    public CaseMaterial(String id, String displayName, boolean enchanted, List<String> lore, int modelData, String[] rgb, Object itemStack) {
        this.id = id;
        this.displayName = displayName;
        this.enchanted = enchanted;
        this.lore = lore;
        this.modelData = modelData;
        this.rgb = rgb;
        this.itemStack = itemStack;
    }

    public void updateMeta() {
        this.updateMeta(this.itemStack, this.displayName, this.lore, this.modelData, this.enchanted, this.rgb);
    }

    public void updateMeta(@NotNull MetaUpdater metaUpdater) {
        metaUpdater.updateMeta(this.itemStack, this.displayName, this.lore, this.modelData, this.enchanted, this.rgb);
    }

    @Override
    public void updateMeta(Object itemStack, String displayName, List<String> lore, int modelData, boolean enchanted, String[] rgb) {
        DCAPI.getInstance().getPlatform().getMetaUpdater().updateMeta(itemStack, displayName, lore, modelData, enchanted, rgb);
    }

    public CaseMaterial clone() {
        try {
            CaseMaterial cloned = (CaseMaterial)super.clone();
            if (this.itemStack instanceof Cloneable) {
                cloned.itemStack = this.cloneItemStack(this.itemStack);
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private Object cloneItemStack(Object itemStack) {
        try {
            return itemStack.getClass().getMethod("clone", new Class[0]).invoke(itemStack, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to clone itemStack", e);
        }
    }

    @Generated
    public void id(String id) {
        this.id = id;
    }

    @Generated
    public void displayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void enchanted(boolean enchanted) {
        this.enchanted = enchanted;
    }

    @Generated
    public void lore(List<String> lore) {
        this.lore = lore;
    }

    @Generated
    public void modelData(int modelData) {
        this.modelData = modelData;
    }

    @Generated
    public void rgb(String[] rgb) {
        this.rgb = rgb;
    }

    @Generated
    public void itemStack(Object itemStack) {
        this.itemStack = itemStack;
    }

    @Generated
    public String id() {
        return this.id;
    }

    @Generated
    public String displayName() {
        return this.displayName;
    }

    @Generated
    public boolean enchanted() {
        return this.enchanted;
    }

    @Generated
    public List<String> lore() {
        return this.lore;
    }

    @Generated
    public int modelData() {
        return this.modelData;
    }

    @Generated
    public String[] rgb() {
        return this.rgb;
    }

    @Generated
    public Object itemStack() {
        return this.itemStack;
    }
}

