/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.event.plugin;

import com.jodexindustries.donatecase.api.event.DCEvent;
import lombok.Generated;
import net.kyori.event.Cancellable;
import org.jetbrains.annotations.NotNull;

public class KeysTransactionEvent
extends DCEvent
implements Cancellable {
    @NotNull
    private final String caseType;
    @NotNull
    private final String source;
    private int amount;
    private final int before;
    private int after;
    @NotNull
    private TransactionType transactionType;
    private boolean cancelled = false;

    public KeysTransactionEvent(@NotNull String caseType, @NotNull String source, int after, int before) {
        this.caseType = caseType;
        this.source = source;
        this.before = before;
        this.after(after);
    }

    public void after(int after) {
        this.after = after;
        if (this.before == after) {
            this.amount = 0;
            this.transactionType = TransactionType.NOTHING;
        } else if (this.before > after) {
            this.amount = this.before - after;
            this.transactionType = TransactionType.REMOVE;
        } else {
            this.amount = after - this.before;
            this.transactionType = TransactionType.ADD;
        }
    }

    @Override
    public boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public void cancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeysTransactionEvent)) {
            return false;
        }
        KeysTransactionEvent other = (KeysTransactionEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.amount() != other.amount()) {
            return false;
        }
        if (this.before() != other.before()) {
            return false;
        }
        if (this.after() != other.after()) {
            return false;
        }
        if (this.cancelled() != other.cancelled()) {
            return false;
        }
        String this$caseType = this.caseType();
        String other$caseType = other.caseType();
        if (this$caseType == null ? other$caseType != null : !this$caseType.equals(other$caseType)) {
            return false;
        }
        String this$source = this.source();
        String other$source = other.source();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        TransactionType this$transactionType = this.transactionType();
        TransactionType other$transactionType = other.transactionType();
        return !(this$transactionType == null ? other$transactionType != null : !((Object)((Object)this$transactionType)).equals((Object)other$transactionType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeysTransactionEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.amount();
        result = result * 59 + this.before();
        result = result * 59 + this.after();
        result = result * 59 + (this.cancelled() ? 79 : 97);
        String $caseType = this.caseType();
        result = result * 59 + ($caseType == null ? 43 : $caseType.hashCode());
        String $source = this.source();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        TransactionType $transactionType = this.transactionType();
        result = result * 59 + ($transactionType == null ? 43 : ((Object)((Object)$transactionType)).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String caseType() {
        return this.caseType;
    }

    @NotNull
    @Generated
    public String source() {
        return this.source;
    }

    @Generated
    public int amount() {
        return this.amount;
    }

    @Generated
    public int before() {
        return this.before;
    }

    @Generated
    public int after() {
        return this.after;
    }

    @NotNull
    @Generated
    public TransactionType transactionType() {
        return this.transactionType;
    }

    @Generated
    public KeysTransactionEvent amount(int amount) {
        this.amount = amount;
        return this;
    }

    @Generated
    public KeysTransactionEvent transactionType(@NotNull TransactionType transactionType) {
        if (transactionType == null) {
            throw new NullPointerException("transactionType is marked non-null but is null");
        }
        this.transactionType = transactionType;
        return this;
    }

    @Generated
    public String toString() {
        return "KeysTransactionEvent(caseType=" + this.caseType() + ", source=" + this.source() + ", amount=" + this.amount() + ", before=" + this.before() + ", after=" + this.after() + ", transactionType=" + (Object)((Object)this.transactionType()) + ", cancelled=" + this.cancelled() + ")";
    }

    public static enum TransactionType {
        ADD,
        REMOVE,
        NOTHING;

    }
}

