/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.manager;

import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.data.ActiveCase;
import com.jodexindustries.donatecase.api.data.animation.CaseAnimation;
import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.data.casedata.CaseDataItem;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AnimationManager {
    public boolean register(CaseAnimation var1);

    public void unregister(@NotNull String var1);

    default public void unregister(Addon addon) {
        ArrayList<CaseAnimation> list = new ArrayList<CaseAnimation>(this.get(addon));
        list.stream().map(CaseAnimation::getName).forEach(this::unregister);
    }

    public void unregister();

    public CompletableFuture<UUID> start(@NotNull DCPlayer var1, @NotNull CaseLocation var2, @NotNull CaseDefinition var3);

    public CompletableFuture<UUID> start(@NotNull DCPlayer var1, @NotNull CaseLocation var2, @NotNull CaseDefinition var3, int var4);

    public CompletableFuture<UUID> start(@NotNull DCPlayer var1, @NotNull CaseLocation var2, @NotNull CaseDefinition var3, boolean var4, int var5);

    @Deprecated
    default public CompletableFuture<UUID> start(@NotNull DCPlayer player, @NotNull CaseLocation location, @NotNull CaseData caseData) {
        return this.start(player, location, CaseData.toDefinition(caseData));
    }

    @Deprecated
    default public CompletableFuture<UUID> start(@NotNull DCPlayer player, @NotNull CaseLocation location, @NotNull CaseData caseData, int delay) {
        return this.start(player, location, CaseData.toDefinition(caseData), delay);
    }

    @Deprecated
    default public CompletableFuture<UUID> start(@NotNull DCPlayer player, @NotNull CaseLocation location, @NotNull CaseData caseData, boolean keyRemoved, int delay) {
        return this.start(player, location, CaseData.toDefinition(caseData), keyRemoved, delay);
    }

    public void preEnd(UUID var1);

    @Deprecated
    default public void preEnd(CaseData caseData, DCPlayer player, CaseDataItem item) {
        this.preEnd(CaseData.toDefinition(caseData), player, CaseDataItem.toItem(item));
    }

    public void preEnd(CaseDefinition var1, DCPlayer var2, CaseItem var3);

    public void end(UUID var1);

    public boolean isRegistered(String var1);

    @Nullable
    public CaseAnimation get(String var1);

    default public List<CaseAnimation> get(Addon addon) {
        return this.getMap().values().stream().filter(animation -> animation.getAddon().equals(addon)).collect(Collectors.toList());
    }

    public Map<String, CaseAnimation> getMap();

    public Map<UUID, ActiveCase> getActiveCases();

    public Map<CaseLocation, List<UUID>> getActiveCasesByBlock();

    default public List<ActiveCase> getActiveCasesByBlock(CaseLocation block) {
        List<ActiveCase> activeCases = new ArrayList<ActiveCase>();
        List uuidList = this.getActiveCasesByBlock().entrySet().stream().filter(entry -> ((CaseLocation)entry.getKey()).equals(block)).findFirst().map(Map.Entry::getValue).orElse(null);
        if (uuidList == null) {
            return activeCases;
        }
        activeCases = uuidList.stream().map(uuid -> this.getActiveCases().get(uuid)).collect(Collectors.toList());
        return activeCases;
    }

    default public boolean isLocked(CaseLocation block) {
        return this.getActiveCasesByBlock(block).stream().anyMatch(ActiveCase::locked);
    }
}

