/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.manager;

import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.data.material.CaseMaterial;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MaterialManager {
    public void register(CaseMaterial var1);

    public void unregister(String var1);

    default public void unregister(Addon addon) {
        ArrayList<CaseMaterial> list = new ArrayList<CaseMaterial>(this.get(addon));
        list.stream().map(CaseMaterial::id).forEach(this::unregister);
    }

    public void unregister();

    public boolean isRegistered(String var1);

    @Nullable
    public CaseMaterial get(@NotNull String var1);

    default public List<CaseMaterial> get(Addon addon) {
        return this.getMap().values().stream().filter(material -> material.addon().equals(addon)).collect(Collectors.toList());
    }

    @NotNull
    public Map<String, CaseMaterial> getMap();

    default public Optional<String> getByStart(@NotNull String string) {
        return this.getMap().keySet().stream().filter(string::startsWith).findFirst();
    }
}

