/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.tools;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.armorstand.ArmorStandCreator;
import com.jodexindustries.donatecase.api.chat.ColorUtils;
import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseInventory;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.data.material.CaseMaterial;
import com.jodexindustries.donatecase.api.data.material.CaseMaterialException;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.data.subcommand.SubCommand;
import com.jodexindustries.donatecase.api.manager.MaterialManager;
import com.jodexindustries.donatecase.api.platform.DCCommandSender;
import com.jodexindustries.donatecase.api.platform.DCOfflinePlayer;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.api.tools.Placeholder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DCTools {
    public abstract CaseInventory createInventory(int var1, @Nullable String var2);

    public abstract ArmorStandCreator createArmorStand(UUID var1, CaseLocation var2);

    @Nullable
    public abstract Object loadCaseItem(String var1);

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat(DCAPI.getInstance().getConfigManager().getConfig().dateFormat());
    }

    public static boolean isValidPlayerName(String player) {
        if (DCAPI.getInstance().getConfigManager().getConfig().checkPlayerName()) {
            return Arrays.stream(DCAPI.getInstance().getPlatform().getOfflinePlayers()).map(DCOfflinePlayer::getName).anyMatch(name -> name != null && name.equals(player.trim()));
        }
        return true;
    }

    @NotNull
    public static List<String> resolveSDGCompletions(String[] args) {
        List value = DCAPI.getInstance().getCaseManager().definitions().stream().map(def -> def.settings().type()).collect(Collectors.toList());
        List<String> list = new ArrayList<String>();
        if (args.length == 1) {
            list.addAll(Arrays.stream(DCAPI.getInstance().getPlatform().getOnlinePlayers()).map(DCPlayer::getName).filter(px -> px.startsWith(args[0])).collect(Collectors.toList()));
            return list;
        }
        if (args.length >= 3) {
            if (args.length == 4) {
                list.add("-s");
                return list;
            }
            return new ArrayList<String>();
        }
        if (args[args.length - 1].isEmpty()) {
            list = value;
        } else {
            list.addAll(value.stream().filter(tmp -> tmp.startsWith(args[args.length - 1])).collect(Collectors.toList()));
        }
        return list;
    }

    @Nullable
    public static Object getItemFromManager(@NotNull String id) {
        CaseMaterial caseMaterial;
        MaterialManager manager = DCAPI.getInstance().getMaterialManager();
        Optional<String> temp = manager.getByStart(id);
        if (temp.isPresent() && (caseMaterial = manager.get(temp.get())) != null) {
            String context = id.replace(temp.get(), "").replaceFirst(":", "").trim();
            try {
                return caseMaterial.handle(context);
            }
            catch (CaseMaterialException e) {
                DCAPI.getInstance().getPlatform().getLogger().log(Level.WARNING, "Error with handling material " + context, e);
            }
        }
        return null;
    }

    public static String prefix(String text) {
        return DCTools.rc(DCAPI.getInstance().getConfigManager().getMessages().getString("prefix") + text);
    }

    public static String rc(String text) {
        if (text == null) {
            return null;
        }
        return ColorUtils.color(text);
    }

    public static String rt(String text, Placeholder ... placeholders) {
        if (text == null || placeholders.length == 0) {
            return text;
        }
        return DCTools.rt(text, Arrays.asList(placeholders));
    }

    public static String rt(String text, Collection<? extends Placeholder> placeholders) {
        if (text == null || placeholders == null || placeholders.isEmpty()) {
            return text;
        }
        StringBuilder result = new StringBuilder(text);
        for (Placeholder placeholder : placeholders) {
            int index;
            while ((index = result.indexOf(placeholder.name())) != -1) {
                result.replace(index, index + placeholder.name().length(), placeholder.value());
            }
        }
        return DCTools.rc(result.toString());
    }

    public static List<String> rt(List<String> text, Collection<? extends Placeholder> placeholders) {
        if (text == null) {
            return null;
        }
        return text.stream().map(t -> DCTools.rt(t, placeholders)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<String> rt(List<String> text, Placeholder ... placeholders) {
        if (text == null) {
            return null;
        }
        return text.stream().map(t -> DCTools.rt(t, placeholders)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<String> rc(List<String> list) {
        if (list == null) {
            return null;
        }
        return list.stream().map(DCTools::rc).collect(Collectors.toCollection(ArrayList::new));
    }

    public static boolean isHasCommandForSender(DCCommandSender sender, Map<String, List<Map<String, SubCommand>>> addonsMap) {
        return addonsMap.keySet().stream().map(addonsMap::get).anyMatch(commands -> DCTools.isHasCommandForSender(sender, commands));
    }

    public static boolean isHasCommandForSender(DCCommandSender sender, List<Map<String, SubCommand>> commands) {
        return commands.stream().flatMap(command -> command.values().stream()).map(SubCommand::permission).anyMatch(permission -> permission == null || sender.hasPermission((String)permission));
    }

    public static String getLocalPlaceholder(String string) {
        Pattern pattern = Pattern.compile("%(.*?)%");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            int startIndex = string.indexOf("%") + 1;
            int endIndex = string.lastIndexOf("%");
            return string.substring(startIndex, endIndex);
        }
        return "null";
    }

    public static int getPluginVersion(String version) {
        if ((version = version.replaceAll("\\.", "")).length() == 4) {
            return Integer.parseInt(version);
        }
        version = version.concat("0000");
        return Integer.parseInt(version.substring(0, 4));
    }

    public static int extractCooldown(String action) {
        Pattern pattern = Pattern.compile("\\[cooldown:(.*?)]");
        Matcher matcher = pattern.matcher(action);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }

    public static List<CaseData.History> sortHistoryDataByCase(List<CaseData.History> historyData, String caseType) {
        ArrayList<CaseData.History> list = new ArrayList<CaseData.History>();
        for (CaseData.History data : historyData) {
            if (data == null || !data.caseType().equals(caseType)) continue;
            list.add(data);
        }
        list.sort(Comparator.comparingLong(object -> ((CaseData.History)object).time()).reversed());
        return list;
    }

    public static List<CaseData.History> sortHistoryDataByDate(List<CaseData.History> list) {
        return list.stream().filter(Objects::nonNull).sorted(Comparator.comparingLong(object -> ((CaseData.History)object).time()).reversed()).collect(Collectors.toList());
    }

    public static Map<String, CaseItem> sortItemsByIndex(Map<String, CaseItem> items) {
        return items.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingInt(CaseItem::index))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public static boolean isValidGuiSize(int size) {
        return size >= 9 && size <= 54 && size % 9 == 0;
    }
}

