/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.tools;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SplittableRandom;
import java.util.TreeSet;
import lombok.Generated;

public final class ProbabilityCollection<E> {
    private final NavigableSet<ProbabilitySetElement<E>> collection;
    private final SplittableRandom random = new SplittableRandom();
    private double totalProbability = 0.0;

    public ProbabilityCollection() {
        this.collection = new TreeSet<ProbabilitySetElement>(Comparator.comparingDouble(rec$ -> ((ProbabilitySetElement)rec$).getIndex()));
    }

    public int size() {
        return this.collection.size();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public boolean contains(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot check if null object is contained in this collection");
        }
        return this.collection.stream().anyMatch(entry -> entry.getObject().equals(object));
    }

    public Iterator<ProbabilitySetElement<E>> iterator() {
        return this.collection.iterator();
    }

    public void add(E object, double probability) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot add null object");
        }
        if (probability <= 0.0) {
            probability = 1.0;
        }
        ProbabilitySetElement entry = new ProbabilitySetElement(object, probability);
        entry.setIndex(this.totalProbability + 1.0);
        this.collection.add(entry);
        this.totalProbability += probability;
    }

    public boolean remove(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot remove null object");
        }
        Iterator<ProbabilitySetElement<E>> it = this.iterator();
        boolean removed = false;
        while (it.hasNext()) {
            ProbabilitySetElement<E> entry = it.next();
            if (!entry.getObject().equals(object)) continue;
            this.totalProbability -= entry.getProbability();
            it.remove();
            removed = true;
        }
        if (removed) {
            double previousIndex = 0.0;
            for (ProbabilitySetElement<E> entry : this.collection) {
                previousIndex = ((ProbabilitySetElement)entry).setIndex(previousIndex + 1.0) + (entry.getProbability() - 1.0);
            }
        }
        return removed;
    }

    public void clear() {
        this.collection.clear();
        this.totalProbability = 0.0;
    }

    public E get() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot get an object out of a empty collection");
        }
        ProbabilitySetElement toFind = new ProbabilitySetElement(null, 0.0);
        toFind.setIndex(this.random.nextDouble(1.0, this.totalProbability + 1.0));
        return (E)Objects.requireNonNull(this.collection.floor(toFind)).getObject();
    }

    @Generated
    public double getTotalProbability() {
        return this.totalProbability;
    }

    public static final class ProbabilitySetElement<T> {
        private final T object;
        private final double probability;
        private double index;

        private ProbabilitySetElement(T object, double probability) {
            this.object = object;
            this.probability = probability;
        }

        private double getIndex() {
            return this.index;
        }

        private double setIndex(double index) {
            this.index = index;
            return this.index;
        }

        @Generated
        public T getObject() {
            return this.object;
        }

        @Generated
        public double getProbability() {
            return this.probability;
        }
    }
}

