/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config;

import com.jodexindustries.donatecase.api.config.Config;
import com.jodexindustries.donatecase.api.config.converter.ConfigType;
import com.jodexindustries.donatecase.api.data.casedata.CaseDataMaterial;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseGui;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItems;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMaterial;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMenu;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseSettings;
import com.jodexindustries.donatecase.api.data.config.ConfigSerializer;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.common.config.converter.DefaultConfigType;
import com.jodexindustries.donatecase.common.config.serializer.CaseDataMaterialSerializer;
import com.jodexindustries.donatecase.common.config.serializer.CaseGuiSerializer;
import com.jodexindustries.donatecase.common.config.serializer.casedefinition.CaseItemSerializer;
import com.jodexindustries.donatecase.common.config.serializer.casedefinition.CaseItemsSerializer;
import com.jodexindustries.donatecase.common.config.serializer.casedefinition.CaseMaterialSerializer;
import com.jodexindustries.donatecase.common.config.serializer.casedefinition.CaseMenuSerializer;
import com.jodexindustries.donatecase.common.config.serializer.casedefinition.CaseSettingsSerializer;
import java.io.File;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class ConfigImpl
implements Config {
    public static final TypeSerializerCollection.Builder SERIALIZER_COLLECTION = TypeSerializerCollection.builder().register(CaseSettings.class, (TypeSerializer)new CaseSettingsSerializer()).register(CaseSettings.Hologram.class, (TypeSerializer)new CaseSettingsSerializer.Hologram()).register(CaseSettings.LevelGroups.class, (TypeSerializer)new CaseSettingsSerializer.LevelGroups()).register(CaseItems.class, (TypeSerializer)new CaseItemsSerializer()).register(CaseItem.class, (TypeSerializer)new CaseItemSerializer()).register(CaseItem.RandomAction.class, (TypeSerializer)new CaseItemSerializer.RandomAction()).register(CaseMenu.class, (TypeSerializer)new CaseMenuSerializer()).register(CaseMenu.Item.class, (TypeSerializer)new CaseMenuSerializer.Item()).register(CaseMaterial.class, (TypeSerializer)new CaseMaterialSerializer()).register(CaseLocation.class, (TypeSerializer)new CaseLocation()).register(CaseGui.class, (TypeSerializer)new CaseGuiSerializer()).register(CaseGui.Item.class, (TypeSerializer)new CaseGuiSerializer.Item()).register(CaseDataMaterial.class, (TypeSerializer)new CaseDataMaterialSerializer());
    private final String path;
    private final File file;
    private final YamlConfigurationLoader loader;
    private int version;
    private ConfigType type;
    private ConfigurationNode node;
    private Object serialized;
    private boolean deleted;

    public ConfigImpl(File file) {
        this(file, null);
    }

    public ConfigImpl(File file, ConfigType type) {
        this.path = file.getPath().replace("\\", "/");
        this.file = file;
        this.type = type;
        this.loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().nodeStyle(NodeStyle.BLOCK).defaultOptions(opts -> opts.serializers(build -> build.registerAll(SERIALIZER_COLLECTION.build())))).file(file)).build();
    }

    private void setMeta() throws SerializationException {
        ConfigSerializer configSerializer;
        ConfigurationNode metaNode = this.node.node(new Object[]{"config"});
        String version = metaNode.node(new Object[]{"version"}).getString();
        if (version != null) {
            this.version = this.parse(version);
            if (this.type == null) {
                this.type = DefaultConfigType.getType(metaNode.node(new Object[]{"type"}).getString());
            }
        } else {
            this.version = this.parse(metaNode.getString());
            if (this.type == null) {
                ConfigType configType = this.type = this.node.hasChild(new Object[]{"case"}) ? DefaultConfigType.OLD_CASE : DefaultConfigType.UNKNOWN;
            }
        }
        if ((configSerializer = this.type.getConfigSerializer()) != null) {
            this.serialized = this.node(configSerializer.path()).get(configSerializer.serializer());
        }
    }

    private int parse(String string) {
        if (string == null) {
            return 0;
        }
        if (string.contains(".")) {
            string = string.replace(".", "");
        }
        return Integer.parseInt(string);
    }

    @Override
    public void type(ConfigType type) {
        this.type = type;
    }

    @Override
    public ConfigurationNode node() {
        return this.node;
    }

    @Override
    @Nullable
    public <T> T getSerialized(Class<T> clazz) {
        return clazz.cast(this.serialized);
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public void load() throws ConfigurateException {
        this.node = this.loader.load();
        this.setMeta();
    }

    @Override
    public boolean delete() {
        this.deleted = this.file.delete();
        return this.deleted;
    }

    @Override
    public void save() throws ConfigurateException {
        if (!this.deleted) {
            this.loader.save(this.node);
        }
    }

    public String toString() {
        return this.path;
    }

    @Override
    @Generated
    public String path() {
        return this.path;
    }

    @Generated
    public YamlConfigurationLoader loader() {
        return this.loader;
    }

    @Override
    @Generated
    public int version() {
        return this.version;
    }

    @Override
    @Generated
    public ConfigType type() {
        return this.type;
    }

    @Generated
    public Object serialized() {
        return this.serialized;
    }

    @Generated
    public boolean deleted() {
        return this.deleted;
    }

    @Generated
    public void version(int version) {
        this.version = version;
    }

    @Generated
    public void node(ConfigurationNode node) {
        this.node = node;
    }

    @Generated
    public void serialized(Object serialized) {
        this.serialized = serialized;
    }

    @Generated
    public void deleted(boolean deleted) {
        this.deleted = deleted;
    }
}

