/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config;

import com.jodexindustries.donatecase.api.config.Config;
import com.jodexindustries.donatecase.api.config.converter.ConfigType;
import com.jodexindustries.donatecase.api.data.config.ConfigData;
import com.jodexindustries.donatecase.api.event.plugin.DonateCaseReloadEvent;
import com.jodexindustries.donatecase.api.manager.ConfigManager;
import com.jodexindustries.donatecase.common.config.CaseStorageImpl;
import com.jodexindustries.donatecase.common.config.ConfigImpl;
import com.jodexindustries.donatecase.common.config.MessagesImpl;
import com.jodexindustries.donatecase.common.config.converter.ConfigConverter;
import com.jodexindustries.donatecase.common.config.converter.DefaultConfigType;
import com.jodexindustries.donatecase.common.database.CaseDatabaseImpl;
import com.jodexindustries.donatecase.common.managers.CaseKeyManagerImpl;
import com.jodexindustries.donatecase.common.managers.CaseOpenManagerImpl;
import com.jodexindustries.donatecase.common.platform.BackendPlatform;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;

public class ConfigManagerImpl
implements ConfigManager {
    private ConfigData configData;
    private final MessagesImpl messages;
    private final CaseStorageImpl caseStorage;
    private final ConfigConverter converter;
    private final Map<String, ConfigImpl> configurations = new HashMap<String, ConfigImpl>();
    private static final String[] defaultFiles = new String[]{"Config.yml", "Cases.yml", "Animations.yml"};
    private final BackendPlatform platform;

    public ConfigManagerImpl(BackendPlatform platform) {
        this.platform = platform;
        this.caseStorage = new CaseStorageImpl(this);
        this.messages = new MessagesImpl(this);
        this.converter = new ConfigConverter(this);
    }

    @Override
    @Nullable
    public ConfigImpl getConfig(@NotNull String name) {
        return this.configurations.get("plugins/DonateCase/" + name);
    }

    @NotNull
    public Optional<ConfigImpl> getConfig(@NotNull ConfigType type) {
        return this.configurations.values().stream().filter(value -> type.equals(value.type())).findFirst();
    }

    @Override
    @Nullable
    public ConfigurationNode getNode(@NotNull String name) {
        ConfigImpl config = this.getConfig(name);
        return config != null ? config.node() : null;
    }

    public Map<String, ? extends ConfigImpl> get() {
        return this.configurations;
    }

    @Override
    public ConfigData getConfig() {
        return this.getConfig(false);
    }

    private ConfigData getConfig(boolean refresh) {
        if (!refresh && this.configData != null) {
            return this.configData;
        }
        Config config = this.getConfig("Config.yml");
        if (config == null && (config = (Config)this.getConfig(DefaultConfigType.CONFIG).orElse(null)) == null) {
            throw new IllegalStateException("DonateCase config is null!");
        }
        this.configData = config.getSerialized(ConfigData.class);
        return this.configData;
    }

    @Override
    public void load() {
        this.configurations.clear();
        this.createFiles();
        this.loadConfigurations(this.platform.getDataFolder().listFiles(), false);
        try {
            this.messages.load(this.getConfig(true).languages());
            this.caseStorage.load();
        }
        catch (ConfigurateException e) {
            this.platform.getLogger().log(Level.WARNING, "Error with loading configuration: ", e);
        }
        this.converter.convert();
        long caching = this.getConfig().caching();
        if (caching >= 0L) {
            CaseOpenManagerImpl.cache.setMaxAge(caching);
            CaseKeyManagerImpl.cache.setMaxAge(caching);
            CaseDatabaseImpl.cache.setMaxAge(caching);
        }
        this.platform.getAPI().getEventBus().post(new DonateCaseReloadEvent(DonateCaseReloadEvent.Type.CONFIG));
    }

    private void loadConfigurations(File[] files, boolean deep) {
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                String dirName = file.getName().toLowerCase();
                File[] subFiles = file.listFiles();
                if (deep || "cases".equals(dirName)) {
                    this.loadConfigurations(subFiles, true);
                    continue;
                }
                if (!"lang".equals(dirName)) continue;
                this.loadConfigurations(subFiles, false);
                continue;
            }
            String fileName = file.getName().toLowerCase();
            if (!fileName.endsWith(".yml") && !fileName.endsWith(".yaml")) continue;
            this.load(file);
        }
    }

    @Override
    public ConfigImpl load(@NotNull File file) {
        String path = file.getPath().replace("\\", "/");
        ConfigImpl exist = this.configurations.get(path);
        if (exist != null) {
            return exist;
        }
        ConfigImpl config = new ConfigImpl(file);
        try {
            config.load();
            this.configurations.put(config.path(), config);
        }
        catch (ConfigurateException e) {
            this.platform.getLogger().log(Level.WARNING, "Error with loading configuration: ", e);
        }
        return config;
    }

    @Override
    @Nullable
    public ConfigImpl unload(@NotNull String name) {
        return this.configurations.remove(name);
    }

    private void createFiles() {
        for (String fileName : defaultFiles) {
            File file = new File(this.platform.getDataFolder(), fileName);
            if (file.exists()) continue;
            this.platform.saveResource(fileName, false);
        }
    }

    @Override
    @NotNull
    public MessagesImpl getMessages() {
        return this.messages;
    }

    @Override
    @NotNull
    public CaseStorageImpl getCaseStorage() {
        return this.caseStorage;
    }

    @Generated
    public BackendPlatform getPlatform() {
        return this.platform;
    }
}

