/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config;

import com.jodexindustries.donatecase.api.config.Messages;
import com.jodexindustries.donatecase.common.config.ConfigImpl;
import com.jodexindustries.donatecase.common.config.ConfigManagerImpl;
import com.jodexindustries.donatecase.common.platform.BackendPlatform;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.serialize.SerializationException;

public class MessagesImpl
implements Messages {
    private static final String DEFAULT_LANG = "lang/en_US.yml";
    private final ConfigManagerImpl configManager;
    private final BackendPlatform platform;
    private ConfigImpl config;

    public MessagesImpl(ConfigManagerImpl configManager) {
        this.configManager = configManager;
        this.platform = configManager.getPlatform();
    }

    @Override
    @NotNull
    public ConfigImpl get() {
        return this.config;
    }

    @Override
    @NotNull
    public String getString(Object ... path) {
        String value = this.config.node(path).getString();
        return value == null ? "" : value;
    }

    @Override
    @NotNull
    public String getString(@NotNull String path, @NotNull String def) {
        return this.config.node(path.split("\\.")).getString(def);
    }

    @Override
    @NotNull
    public List<String> getStringList(@NotNull String path) {
        try {
            return this.config.node(path).getList(String.class, new ArrayList());
        }
        catch (SerializationException e) {
            return new ArrayList<String>();
        }
    }

    @Override
    public void load(@NotNull String language) throws ConfigurateException {
        String path = "lang/" + language + ".yml";
        ConfigImpl config = this.configManager.getConfig(path);
        if (config == null) {
            if (this.platform.getResource(path) != null) {
                this.platform.saveResource(path, false);
                config = this.configManager.load(new File(this.platform.getDataFolder(), path));
            } else {
                config = this.loadDefault();
                this.platform.getLogger().warning("Language file \"" + language + "\" was not found! Using the default \"en_US\"");
            }
        }
        if (config == null) {
            throw new ConfigurateException("Failed to load messages configuration: " + path);
        }
        this.config = config;
    }

    private ConfigImpl loadDefault() {
        File defaultLang = new File(this.platform.getDataFolder(), DEFAULT_LANG);
        if (!defaultLang.exists()) {
            this.platform.saveResource(DEFAULT_LANG, false);
        }
        return this.configManager.load(defaultLang);
    }
}

