/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.converter;

import com.jodexindustries.donatecase.api.config.Config;
import com.jodexindustries.donatecase.api.config.converter.ConfigMigrator;
import com.jodexindustries.donatecase.api.config.converter.ConfigType;
import com.jodexindustries.donatecase.common.config.ConfigImpl;
import com.jodexindustries.donatecase.common.config.ConfigManagerImpl;
import java.util.ArrayList;
import java.util.logging.Level;
import org.spongepowered.configurate.ConfigurateException;

public class ConfigConverter {
    private final ConfigManagerImpl configManager;

    public ConfigConverter(ConfigManagerImpl configManager) {
        this.configManager = configManager;
    }

    public void convert() {
        for (Config config : new ArrayList<ConfigImpl>(this.configManager.get().values())) {
            try {
                this.convert(config);
            }
            catch (ConfigurateException e) {
                this.configManager.getPlatform().getLogger().log(Level.WARNING, "Error with converting configuration: " + config, e);
            }
        }
    }

    public void convert(Config config) throws ConfigurateException, IllegalArgumentException {
        ConfigMigrator migrator;
        ConfigType type;
        int version = config.version();
        if (version == (type = config.type()).getLatestVersion() && !type.isPermanent()) {
            return;
        }
        while ((version < type.getLatestVersion() || type.isPermanent()) && (migrator = type.getMigrator(version)) != null) {
            this.configManager.getPlatform().getLogger().info(config + " converting...");
            migrator.migrate(config);
            if (type.isPermanent()) {
                this.configManager.getPlatform().getLogger().info(config + " converted permanently from UNKNOWN to " + config.type());
                this.convert(config);
                break;
            }
            this.configManager.getPlatform().getLogger().info(config + " converted from " + version + " to " + ++version);
        }
        config.save();
    }
}

