/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.converter.migrators;

import com.jodexindustries.donatecase.api.config.Config;
import com.jodexindustries.donatecase.api.config.converter.ConfigMigrator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class LanguageMigrator_2_6_to_2_7
implements ConfigMigrator {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(%\\w+)(?!%)");

    @Override
    public void migrate(Config config) throws SerializationException {
        LanguageMigrator_2_6_to_2_7.updatePlaceholders(config.node());
        config.node("config", "version").set((Object)27);
    }

    private static void updatePlaceholders(ConfigurationNode node) throws SerializationException {
        if (node.isMap()) {
            for (Map.Entry entry : node.childrenMap().entrySet()) {
                LanguageMigrator_2_6_to_2_7.updatePlaceholders((ConfigurationNode)entry.getValue());
            }
        } else if (node.isList()) {
            for (ConfigurationNode child : node.childrenList()) {
                LanguageMigrator_2_6_to_2_7.updatePlaceholders(child);
            }
        } else {
            Matcher matcher;
            String updatedValue;
            String value;
            Object rawValue = node.raw();
            if (rawValue instanceof String && !(value = (String)rawValue).equals(updatedValue = (matcher = PLACEHOLDER_PATTERN.matcher(value)).replaceAll("$1%"))) {
                node.set((Object)updatedValue);
            }
        }
    }
}

