/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.serializer;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.casedata.CaseDataMaterial;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseGui;
import com.jodexindustries.donatecase.api.data.casedata.gui.typeditem.TypedItem;
import com.jodexindustries.donatecase.api.tools.DCTools;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class CaseGuiSerializer
implements TypeSerializer<CaseGui> {
    @Deprecated
    public CaseGui deserialize(Type type, ConfigurationNode source) throws SerializationException {
        CaseGui caseGui = new CaseGui();
        String title = source.node(new Object[]{"Title"}).getString();
        int updateRate = source.node(new Object[]{"UpdateRate"}).getInt();
        int size = source.node(new Object[]{"Size"}).getInt();
        caseGui.title(title);
        caseGui.updateRate(updateRate);
        caseGui.size(size);
        if (!DCTools.isValidGuiSize(size)) {
            caseGui.size(54);
            DCAPI.getInstance().getPlatform().getLogger().warning("Wrong GUI size: " + size);
        }
        HashMap<String, CaseGui.Item> itemMap = new HashMap<String, CaseGui.Item>();
        ConfigurationNode itemsNode = source.node(new Object[]{"Items"});
        HashSet<Integer> slots = new HashSet<Integer>();
        if (itemsNode != null) {
            for (Map.Entry entry : itemsNode.childrenMap().entrySet()) {
                CaseGui.Item item = this.loadGUIItem(String.valueOf(entry.getKey()), (ConfigurationNode)entry.getValue(), slots);
                if (item == null) continue;
                itemMap.put((String)item.node().key(), item);
            }
        }
        caseGui.items(itemMap);
        return caseGui;
    }

    public void serialize(Type type, @Nullable CaseGui obj, ConfigurationNode target) {
    }

    @Deprecated
    private CaseGui.Item loadGUIItem(String i, @NotNull ConfigurationNode itemSection, Set<Integer> currentSlots) throws SerializationException {
        Optional<TypedItem> typedItem;
        CaseGui.Item item = (CaseGui.Item)itemSection.get(CaseGui.Item.class);
        if (item == null) {
            return null;
        }
        if (item.slots().isEmpty()) {
            DCAPI.getInstance().getPlatform().getLogger().warning("Item " + i + " has no specified slots");
            return null;
        }
        if (item.slots().removeIf(currentSlots::contains)) {
            DCAPI.getInstance().getPlatform().getLogger().warning("Item " + i + " contains duplicated slots, removing..");
        }
        currentSlots.addAll(item.slots());
        CaseDataMaterial material = (CaseDataMaterial)itemSection.get(CaseDataMaterial.class);
        if (material == null) {
            return null;
        }
        if (!item.type().equalsIgnoreCase("DEFAULT") && (typedItem = DCAPI.getInstance().getGuiTypedItemManager().getFromString(item.toString())).isPresent() && typedItem.get().loadOnCase()) {
            material.itemStack(DCAPI.getInstance().getPlatform().getTools().loadCaseItem(item.material().id()));
        }
        return item;
    }

    public static class Item
    implements TypeSerializer<CaseGui.Item> {
        @Deprecated
        public CaseGui.Item deserialize(Type type, ConfigurationNode source) throws SerializationException {
            CaseGui.Item item = new CaseGui.Item();
            String itemType = source.node(new Object[]{"Type"}).getString();
            CaseDataMaterial material = (CaseDataMaterial)source.node(new Object[]{"Material"}).get(CaseDataMaterial.class);
            item.type(itemType);
            item.material(material);
            item.node(source);
            item.slots(this.getItemSlots(source));
            return item;
        }

        @Deprecated
        public void serialize(Type type, @Nullable CaseGui.Item obj, ConfigurationNode target) {
        }

        private List<Integer> getItemSlots(ConfigurationNode itemSection) throws SerializationException {
            if (itemSection.node(new Object[]{"Slots"}).isList()) {
                return this.getItemSlotsListed(itemSection);
            }
            return this.getItemSlotsRanged(itemSection);
        }

        private List<Integer> getItemSlotsListed(ConfigurationNode itemSection) throws SerializationException {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            List temp = itemSection.node(new Object[]{"Slots"}).getList(String.class);
            if (temp != null) {
                for (String slot : temp) {
                    String[] values = slot.split("-", 2);
                    if (values.length == 2) {
                        for (int i = Integer.parseInt(values[0]); i <= Integer.parseInt(values[1]); ++i) {
                            slots.add(i);
                        }
                        continue;
                    }
                    slots.add(Integer.parseInt(slot));
                }
            }
            return slots;
        }

        private List<Integer> getItemSlotsRanged(ConfigurationNode itemSection) {
            String slots = itemSection.node(new Object[]{"Slots"}).getString();
            if (slots == null || slots.isEmpty()) {
                return new ArrayList<Integer>();
            }
            String[] slotArgs = slots.split("-");
            int range1 = Integer.parseInt(slotArgs[0]);
            int range2 = slotArgs.length >= 2 ? Integer.parseInt(slotArgs[1]) : range1;
            return IntStream.rangeClosed(range1, range2).boxed().collect(Collectors.toList());
        }
    }
}

