/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.serializer.casedefinition;

import com.jodexindustries.donatecase.api.data.casedata.GiveType;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMaterial;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class CaseItemSerializer
implements TypeSerializer<CaseItem> {
    public CaseItem deserialize(Type type, ConfigurationNode node) throws SerializationException {
        HashMap<String, CaseItem.RandomAction> randomActions = new HashMap<String, CaseItem.RandomAction>();
        ConfigurationNode randomActionsNode = node.node(new Object[]{"random-actions"});
        if (randomActionsNode.isMap()) {
            for (Map.Entry entry : randomActionsNode.childrenMap().entrySet()) {
                randomActions.put(String.valueOf(entry.getKey()), (CaseItem.RandomAction)((ConfigurationNode)entry.getValue()).get(CaseItem.RandomAction.class));
            }
        }
        return new CaseItem(String.valueOf(node.key()), node.node(new Object[]{"group"}).getString(), node.node(new Object[]{"chance"}).getDouble(), node.node(new Object[]{"index"}).getInt(), (CaseMaterial)node.node(new Object[]{"material"}).get(CaseMaterial.class), (GiveType)((Object)node.node(new Object[]{"give-type"}).get(GiveType.class, (Object)GiveType.ONE)), node.node(new Object[]{"actions"}).getList(String.class), node.node(new Object[]{"alternative-actions"}).getList(String.class), randomActions);
    }

    public void serialize(Type type, @Nullable CaseItem obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            return;
        }
        node.node(new Object[]{"group"}).set((Object)obj.group());
        node.node(new Object[]{"chance"}).set((Object)obj.chance());
        node.node(new Object[]{"index"}).set((Object)obj.index());
        node.node(new Object[]{"material"}).set(CaseMaterial.class, (Object)obj.material());
        node.node(new Object[]{"give-type"}).set((Object)obj.giveType());
        node.node(new Object[]{"actions"}).setList(String.class, obj.actions());
        node.node(new Object[]{"alternative-actions"}).setList(String.class, obj.alternativeActions());
        Map<String, CaseItem.RandomAction> randomActions = obj.randomActions();
        if (randomActions != null && !randomActions.isEmpty()) {
            ConfigurationNode randomActionsNode = node.node(new Object[]{"random-actions"});
            for (Map.Entry<String, CaseItem.RandomAction> entry : randomActions.entrySet()) {
                randomActionsNode.node(new Object[]{entry.getKey()}).set(CaseItem.RandomAction.class, (Object)entry.getValue());
            }
        }
    }

    public static class RandomAction
    implements TypeSerializer<CaseItem.RandomAction> {
        public CaseItem.RandomAction deserialize(Type type, ConfigurationNode node) throws SerializationException {
            return new CaseItem.RandomAction(String.valueOf(node.key()), node.node(new Object[]{"chance"}).getDouble(), node.node(new Object[]{"actions"}).getList(String.class), node.node(new Object[]{"display-name"}).getString());
        }

        public void serialize(Type type, @Nullable CaseItem.RandomAction obj, ConfigurationNode node) throws SerializationException {
            if (obj == null) {
                return;
            }
            node.node(new Object[]{"chance"}).set((Object)obj.chance());
            node.node(new Object[]{"actions"}).setList(String.class, obj.actions());
            node.node(new Object[]{"display-name"}).set((Object)obj.displayName());
        }
    }
}

