/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.serializer.casedefinition;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.casedata.gui.typeditem.TypedItem;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMaterial;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMenu;
import com.jodexindustries.donatecase.api.tools.DCTools;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class CaseMenuSerializer
implements TypeSerializer<CaseMenu> {
    public CaseMenu deserialize(Type type, ConfigurationNode node) throws SerializationException {
        int size;
        HashMap<String, CaseMenu.Item> items = new HashMap<String, CaseMenu.Item>();
        ConfigurationNode itemsNode = node.node(new Object[]{"items"});
        if (itemsNode.isMap()) {
            HashSet<Integer> slots = new HashSet<Integer>();
            for (Map.Entry entry : itemsNode.childrenMap().entrySet()) {
                String key = String.valueOf(entry.getKey());
                CaseMenu.Item item = this.loadItem(key, (ConfigurationNode)entry.getValue(), slots);
                if (item == null) continue;
                items.put(key, item);
            }
        }
        if (!DCTools.isValidGuiSize(size = node.node(new Object[]{"size"}).getInt())) {
            size = 54;
            DCAPI.getInstance().getPlatform().getLogger().warning("Wrong GUI size: " + size + ". Using 54");
        }
        return new CaseMenu(node.node(new Object[]{"id"}).getString(), node.node(new Object[]{"title"}).getString(), size, node.node(new Object[]{"update-rate"}).getInt(), items);
    }

    public void serialize(Type type, @Nullable CaseMenu obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            return;
        }
        node.node(new Object[]{"id"}).set((Object)obj.id());
        node.node(new Object[]{"title"}).set((Object)obj.title());
        node.node(new Object[]{"size"}).set((Object)obj.size());
        node.node(new Object[]{"update-rate"}).set((Object)obj.updateRate());
        ConfigurationNode itemsNode = node.node(new Object[]{"items"});
        Map<String, CaseMenu.Item> items = obj.items();
        if (items != null) {
            for (Map.Entry<String, CaseMenu.Item> entry : items.entrySet()) {
                itemsNode.node(new Object[]{entry.getKey()}).set(CaseMenu.Item.class, (Object)entry.getValue());
            }
        }
    }

    private CaseMenu.Item loadItem(String i, @NotNull ConfigurationNode itemSection, Set<Integer> currentSlots) throws SerializationException {
        CaseMenu.Item item = (CaseMenu.Item)itemSection.get(CaseMenu.Item.class);
        if (item == null) {
            return null;
        }
        if (item.slots().isEmpty()) {
            DCAPI.getInstance().getPlatform().getLogger().warning("Item " + i + " has no specified slots");
            return null;
        }
        if (item.slots().removeIf(currentSlots::contains)) {
            DCAPI.getInstance().getPlatform().getLogger().warning("Item " + i + " contains duplicated slots, removing..");
        }
        currentSlots.addAll(item.slots());
        if (!item.type().equalsIgnoreCase("DEFAULT")) {
            Optional<TypedItem> typedItem = DCAPI.getInstance().getGuiTypedItemManager().getFromString(item.type());
            if (typedItem.isPresent() && typedItem.get().loadOnCase()) {
                item.material().itemStack(DCAPI.getInstance().getPlatform().getTools().loadCaseItem(item.material().id()));
            }
        } else {
            item.material().itemStack(null);
        }
        return item;
    }

    public static class Item
    implements TypeSerializer<CaseMenu.Item> {
        public CaseMenu.Item deserialize(Type type, ConfigurationNode node) throws SerializationException {
            return new CaseMenu.Item(node, String.valueOf(node.key()), node.node(new Object[]{"type"}).getString(), (CaseMaterial)node.node(new Object[]{"material"}).get(CaseMaterial.class), this.getItemSlots(node.node(new Object[]{"slots"})));
        }

        public void serialize(Type type, @Nullable CaseMenu.Item obj, ConfigurationNode node) throws SerializationException {
            if (obj == null) {
                return;
            }
            node.node(new Object[]{"type"}).set((Object)obj.type());
            node.node(new Object[]{"material"}).set(CaseMaterial.class, (Object)obj.material());
            node.node(new Object[]{"slots"}).setList(Integer.class, obj.slots());
        }

        private List<Integer> getItemSlots(ConfigurationNode node) throws SerializationException {
            if (node.isList()) {
                return this.getItemSlotsListed(node.getList(String.class));
            }
            return this.getItemSlotsRanged(node.getString());
        }

        private List<Integer> getItemSlotsListed(List<String> temp) {
            if (temp == null || temp.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (String slot : temp) {
                String[] values = slot.split("-", 2);
                try {
                    int start = Integer.parseInt(values[0]);
                    int end = values.length == 2 ? Integer.parseInt(values[1]) : start;
                    this.addRange(slots, start, end);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return slots;
        }

        private List<Integer> getItemSlotsRanged(String slots) {
            if (slots == null || slots.isEmpty()) {
                return Collections.emptyList();
            }
            String[] slotArgs = slots.split("-");
            try {
                int start = Integer.parseInt(slotArgs[0]);
                int end = slotArgs.length >= 2 ? Integer.parseInt(slotArgs[1]) : start;
                ArrayList<Integer> result = new ArrayList<Integer>();
                this.addRange(result, start, end);
                return result;
            }
            catch (NumberFormatException e) {
                return Collections.emptyList();
            }
        }

        private void addRange(List<Integer> slots, int start, int end) {
            for (int i = start; i <= end; ++i) {
                slots.add(i);
            }
        }
    }
}

