/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.database;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.logger.Level;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.data.config.ConfigData;
import com.jodexindustries.donatecase.api.data.database.DatabaseStatus;
import com.jodexindustries.donatecase.api.data.database.DatabaseType;
import com.jodexindustries.donatecase.api.database.CaseDatabase;
import com.jodexindustries.donatecase.common.DonateCase;
import com.jodexindustries.donatecase.common.database.entities.OpenInfoTable;
import com.jodexindustries.donatecase.common.database.entities.PlayerKeysTable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class CaseDatabaseImpl
extends CaseDatabase {
    private Dao<CaseData.History, String> historyDataTables;
    private Dao<PlayerKeysTable, String> playerKeysTables;
    private Dao<OpenInfoTable, String> openInfoTables;
    private JdbcConnectionSource connectionSource;
    private final DonateCase api;
    private final Logger logger;
    private DatabaseType databaseType;

    public CaseDatabaseImpl(DonateCase api) {
        this.api = api;
        this.logger = api.getPlatform().getLogger();
    }

    @Override
    public void connect(String path) {
        try {
            this.close();
            this.connectionSource = new JdbcConnectionSource("jdbc:sqlite:" + path + "/database.db");
            this.databaseType = DatabaseType.SQLITE;
            this.init();
            this.logger.info("Using SQLITE database type!");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void connect(String database, int port, String host, String user, String password) {
        try {
            this.close();
            this.connectionSource = new JdbcConnectionSource("jdbc:mysql://" + host + ":" + port + "/" + database + "?autoReconnect=true", user, password);
            this.databaseType = DatabaseType.MYSQL;
            this.init();
            this.logger.info("Using MYSQL database type!");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void connect() {
        ConfigData.MySQL mysql = this.api.getConfigManager().getConfig().mySQL();
        if (mysql == null || !mysql.enabled()) {
            this.connect(this.api.getPlatform().getDataFolder().getAbsolutePath());
            return;
        }
        this.connect(mysql.database(), mysql.port(), mysql.host(), mysql.user(), mysql.password());
    }

    private void init() throws SQLException {
        com.j256.ormlite.logger.Logger.setGlobalLogLevel((Level)Level.WARNING);
        TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, CaseData.History.class);
        TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, PlayerKeysTable.class);
        TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, OpenInfoTable.class);
        this.historyDataTables = DaoManager.createDao((ConnectionSource)this.connectionSource, CaseData.History.class);
        this.playerKeysTables = DaoManager.createDao((ConnectionSource)this.connectionSource, PlayerKeysTable.class);
        this.openInfoTables = DaoManager.createDao((ConnectionSource)this.connectionSource, OpenInfoTable.class);
    }

    @Override
    public CompletableFuture<Map<String, Integer>> getKeys(String player) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, Integer> keys = new HashMap<String, Integer>();
            try {
                List results = this.playerKeysTables.queryBuilder().where().eq("player", (Object)player).query();
                for (PlayerKeysTable result : results) {
                    keys.put(result.getCaseType(), result.getKeys());
                }
            }
            catch (SQLException e) {
                this.warning(e);
            }
            return keys;
        });
    }

    @Override
    public CompletableFuture<Integer> getKeys(String name, String player) {
        return CompletableFuture.supplyAsync(() -> {
            int keys = 0;
            try {
                List results = this.playerKeysTables.queryBuilder().where().eq("player", (Object)player).and().eq("case_name", (Object)name).query();
                if (!results.isEmpty()) {
                    keys = ((PlayerKeysTable)results.get(0)).getKeys();
                }
            }
            catch (SQLException e) {
                this.warning(e);
            }
            return keys;
        });
    }

    @Override
    public CompletableFuture<DatabaseStatus> setKeys(String name, String player, int keys) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                List results = this.playerKeysTables.queryBuilder().where().eq("player", (Object)player).and().eq("case_name", (Object)name).query();
                PlayerKeysTable playerKeysTable = null;
                if (!results.isEmpty()) {
                    playerKeysTable = (PlayerKeysTable)results.get(0);
                }
                if (playerKeysTable == null) {
                    playerKeysTable = new PlayerKeysTable();
                    playerKeysTable.setPlayer(player);
                    playerKeysTable.setCaseType(name);
                    playerKeysTable.setKeys(keys);
                    this.playerKeysTables.create((Object)playerKeysTable);
                } else {
                    UpdateBuilder updateBuilder = this.playerKeysTables.updateBuilder();
                    updateBuilder.updateColumnValue("keys", (Object)keys);
                    updateBuilder.where().eq("player", (Object)player).and().eq("case_name", (Object)name);
                    updateBuilder.update();
                }
            }
            catch (SQLException e) {
                this.warning(e);
                return DatabaseStatus.FAIL;
            }
            return DatabaseStatus.COMPLETE;
        });
    }

    @Override
    public CompletableFuture<Integer> getOpenCount(String player, String caseType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                List results = this.openInfoTables.queryBuilder().where().eq("player", (Object)player).and().eq("case_type", (Object)caseType).query();
                return results.stream().mapToInt(OpenInfoTable::getCount).sum();
            }
            catch (SQLException e) {
                this.warning(e);
                return 0;
            }
        });
    }

    @Override
    public CompletableFuture<Map<String, Integer>> getOpenCount(String player) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, Integer> opens = new HashMap<String, Integer>();
            try {
                List results = this.openInfoTables.queryBuilder().where().eq("player", (Object)player).query();
                for (OpenInfoTable result : results) {
                    opens.merge(result.getCaseType(), result.getCount(), Integer::sum);
                }
            }
            catch (SQLException e) {
                this.warning(e);
            }
            return opens;
        });
    }

    @Override
    public CompletableFuture<Map<String, Map<String, Integer>>> getGlobalOpenCount() {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, Map> globalMap = new HashMap<String, Map>();
            try {
                List results = this.openInfoTables.queryForAll();
                for (OpenInfoTable result : results) {
                    globalMap.computeIfAbsent(result.getPlayer(), k -> new HashMap()).merge(result.getCaseType(), result.getCount(), Integer::sum);
                }
            }
            catch (SQLException e) {
                this.warning(e);
            }
            return globalMap;
        });
    }

    @Override
    public CompletableFuture<Map<String, Integer>> getGlobalOpenCount(String caseType) {
        return CompletableFuture.supplyAsync(() -> {
            Map<Object, Object> opens = new HashMap();
            try {
                List results = this.openInfoTables.queryBuilder().where().eq("case_type", (Object)caseType).query();
                opens = results.stream().collect(Collectors.toMap(OpenInfoTable::getPlayer, OpenInfoTable::getCount, Integer::sum));
            }
            catch (SQLException e) {
                this.warning(e);
            }
            return opens;
        });
    }

    @Override
    public CompletableFuture<DatabaseStatus> setCount(String caseType, String player, int count) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                List results = this.openInfoTables.queryBuilder().where().eq("player", (Object)player).and().eq("case_type", (Object)caseType).query();
                OpenInfoTable openInfoTable = null;
                if (!results.isEmpty()) {
                    openInfoTable = (OpenInfoTable)results.get(0);
                }
                if (openInfoTable == null) {
                    openInfoTable = new OpenInfoTable();
                    openInfoTable.setPlayer(player);
                    openInfoTable.setCaseType(caseType);
                    openInfoTable.setCount(count);
                    this.openInfoTables.create((Object)openInfoTable);
                } else {
                    UpdateBuilder updateBuilder = this.openInfoTables.updateBuilder();
                    updateBuilder.updateColumnValue("count", (Object)count);
                    updateBuilder.where().eq("player", (Object)player).and().eq("case_type", (Object)caseType);
                    updateBuilder.update();
                }
            }
            catch (SQLException e) {
                this.warning(e);
                return DatabaseStatus.FAIL;
            }
            return DatabaseStatus.COMPLETE;
        });
    }

    @Override
    public CompletableFuture<DatabaseStatus> addHistory(String caseType, CaseData.History newEntry, int maxSize) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                List entries = this.historyDataTables.queryBuilder().orderBy("time", true).where().eq("case_type", (Object)caseType).query();
                if (entries.size() >= maxSize) {
                    CaseData.History oldest = (CaseData.History)entries.get(0);
                    DeleteBuilder deleteBuilder = this.historyDataTables.deleteBuilder();
                    deleteBuilder.where().eq("time", (Object)oldest.time()).and().eq("case_type", (Object)caseType);
                    deleteBuilder.delete();
                }
                this.historyDataTables.create((Object)newEntry);
                return DatabaseStatus.COMPLETE;
            }
            catch (SQLException e) {
                this.warning(e);
                return DatabaseStatus.FAIL;
            }
        });
    }

    private void setHistoryDataTable(CaseData.History historyDataTable, CaseData.History data) throws SQLException {
        if (historyDataTable == null) {
            this.historyDataTables.create((Object)data);
        } else {
            UpdateBuilder updateBuilder = this.historyDataTables.updateBuilder();
            updateBuilder.updateColumnValue("player_name", (Object)data.playerName());
            updateBuilder.updateColumnValue("time", (Object)data.time());
            updateBuilder.updateColumnValue("group", (Object)data.group());
            updateBuilder.updateColumnValue("action", (Object)data.action());
            updateBuilder.where().eq("case_type", (Object)data.caseType()).and().eq("time", (Object)historyDataTable.time());
            updateBuilder.update();
        }
    }

    @Override
    public CompletableFuture<DatabaseStatus> setHistoryData(String caseType, int index, CaseData.History data) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                QueryBuilder queryBuilder = this.historyDataTables.queryBuilder();
                queryBuilder.where().eq("case_type", (Object)caseType);
                List results = queryBuilder.query();
                CaseData.History historyDataTable = results.isEmpty() ? null : (CaseData.History)results.get(index);
                this.setHistoryDataTable(historyDataTable, data);
            }
            catch (SQLException e) {
                this.warning(e);
                return DatabaseStatus.FAIL;
            }
            return DatabaseStatus.COMPLETE;
        });
    }

    @Override
    public CompletableFuture<DatabaseStatus> removeHistoryData(String caseType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                DeleteBuilder deleteBuilder = this.historyDataTables.deleteBuilder();
                deleteBuilder.where().eq("case_type", (Object)caseType);
                deleteBuilder.delete();
                return DatabaseStatus.COMPLETE;
            }
            catch (SQLException e) {
                this.warning(e);
                return DatabaseStatus.FAIL;
            }
        });
    }

    @Override
    public CompletableFuture<DatabaseStatus> removeHistoryData(String caseType, int index) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                DeleteBuilder deleteBuilder = this.historyDataTables.deleteBuilder();
                deleteBuilder.where().eq("case_type", (Object)caseType).and().eq("id", (Object)index);
                deleteBuilder.delete();
                return DatabaseStatus.COMPLETE;
            }
            catch (SQLException e) {
                this.warning(e);
                return DatabaseStatus.FAIL;
            }
        });
    }

    @Override
    public CompletableFuture<List<CaseData.History>> getHistoryData() {
        ArrayList result = new ArrayList();
        return CompletableFuture.supplyAsync(() -> {
            try {
                result.addAll(this.historyDataTables.queryForAll());
            }
            catch (SQLException e) {
                this.warning(e);
            }
            return result;
        });
    }

    @Override
    public CompletableFuture<List<CaseData.History>> getHistoryData(String caseType) {
        ArrayList result = new ArrayList();
        return CompletableFuture.supplyAsync(() -> {
            try {
                result.addAll(this.historyDataTables.queryBuilder().orderBy("time", true).where().eq("case_type", (Object)caseType).query());
            }
            catch (SQLException e) {
                this.warning(e);
            }
            return result;
        });
    }

    @Override
    public List<CaseData.History> getCache() {
        if (this.databaseType == DatabaseType.SQLITE) {
            return this.getHistoryData().join();
        }
        List cachedList = (List)cache.get("all!");
        if (cachedList != null) {
            return cachedList;
        }
        List<CaseData.History> previousList = (List<CaseData.History>)cache.getPrevious("all!");
        this.getHistoryData().thenAcceptAsync(historyData -> cache.put("all!", historyData));
        return previousList != null ? previousList : this.getHistoryData().join();
    }

    @Override
    public List<CaseData.History> getCache(String caseType) {
        if (this.databaseType == DatabaseType.SQLITE) {
            return this.getHistoryData(caseType).join();
        }
        List cachedList = (List)cache.get(caseType);
        if (cachedList != null) {
            return cachedList;
        }
        List<CaseData.History> previousList = (List<CaseData.History>)cache.getPrevious(caseType);
        this.getHistoryData(caseType).thenAcceptAsync(historyData -> cache.put(caseType, historyData));
        return previousList != null ? previousList : this.getHistoryData(caseType).join();
    }

    @Override
    public CompletableFuture<DatabaseStatus> delAllKeys() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.playerKeysTables.deleteBuilder().delete();
            }
            catch (SQLException e) {
                this.warning(e);
                return DatabaseStatus.FAIL;
            }
            return DatabaseStatus.COMPLETE;
        });
    }

    @Override
    public CompletableFuture<DatabaseStatus> delKeys(String caseType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                DeleteBuilder deleteBuilder = this.playerKeysTables.deleteBuilder();
                deleteBuilder.where().eq("case_name", (Object)caseType);
                deleteBuilder.delete();
            }
            catch (SQLException e) {
                this.warning(e);
                return DatabaseStatus.FAIL;
            }
            return DatabaseStatus.COMPLETE;
        });
    }

    @Override
    public void close() {
        if (this.connectionSource != null) {
            try {
                this.connectionSource.close();
            }
            catch (Exception e) {
                this.logger.warning(e.getMessage());
            }
        }
    }

    @Override
    public DatabaseType getType() {
        return this.databaseType;
    }

    private void warning(Throwable e) {
        this.logger.log(java.util.logging.Level.WARNING, "Error with database query:", e);
    }
}

