/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.entity.meta;

import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Metadata {
    private final int entityId;
    private final HashMap<Byte, EntityData<?>> notNotifiedChanges = new HashMap();
    private final ConcurrentHashMap<Byte, EntityData<?>> metadataMap = new ConcurrentHashMap();

    public Metadata(int entityId) {
        this.entityId = entityId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(Metadata other) {
        other.clear();
        HashMap<Byte, EntityData<?>> hashMap = other.notNotifiedChanges;
        synchronized (hashMap) {
            other.notNotifiedChanges.putAll(this.notNotifiedChanges);
        }
        other.metadataMap.putAll(this.metadataMap);
    }

    public void copyFrom(Metadata other) {
        other.copyTo(this);
    }

    public void clear() {
        this.metadataMap.clear();
        this.notNotifiedChanges.clear();
    }

    public <T> T getIndex(byte index, @Nullable T defaultValue) {
        EntityData<?> value = this.metadataMap.get(index);
        return (T)(value != null ? value.getValue() : defaultValue);
    }

    public <T> void setIndex(byte index, @NotNull EntityDataType<T> dataType, T value) {
        EntityData entry = new EntityData((int)index, dataType, value);
        this.metadataMap.put(index, entry);
    }

    public void setMetaFromPacket(WrapperPlayServerEntityMetadata wrapper) {
        for (EntityData data : wrapper.getEntityMetadata()) {
            this.metadataMap.put((byte)data.getIndex(), data);
        }
    }

    @NotNull
    List<EntityData<?>> getEntries() {
        return Collections.unmodifiableList(new ArrayList(this.metadataMap.values()));
    }

    public WrapperPlayServerEntityMetadata createPacket() {
        return new WrapperPlayServerEntityMetadata(this.entityId, this.getEntries());
    }
}

