/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.gui.items;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseGuiWrapper;
import com.jodexindustries.donatecase.api.data.casedata.gui.typeditem.TypedItemException;
import com.jodexindustries.donatecase.api.data.casedata.gui.typeditem.TypedItemHandler;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMaterial;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMenu;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.common.tools.LocalPlaceholder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class HISTORYItemHandlerImpl
implements TypedItemHandler {
    @Override
    @NotNull
    public CaseMenu.Item handle(@NotNull CaseGuiWrapper caseGui, @NotNull CaseMenu.Item item) throws TypedItemException {
        CaseDefinition definition = caseGui.getDefinition();
        boolean handled = this.handleHistoryItem(definition, item, caseGui.getGlobalHistoryData());
        if (!handled) {
            this.applyFallbackMaterial(item);
        }
        return item;
    }

    private void applyFallbackMaterial(CaseMenu.Item item) throws TypedItemException {
        try {
            ConfigurationNode notFoundNode = item.node().node(new Object[]{"HistoryNotFound"});
            if (!notFoundNode.isNull()) {
                item.material((CaseMaterial)notFoundNode.get(CaseMaterial.class));
            } else {
                item.material().id("AIR");
            }
        }
        catch (SerializationException e) {
            throw new TypedItemException("Error serializing 'HistoryNotFound' material", e);
        }
    }

    private boolean handleHistoryItem(CaseDefinition definition, CaseMenu.Item item, List<CaseData.History> globalHistoryData) {
        boolean isGlobal;
        CaseMaterial itemMaterial = item.material();
        String[] typeArgs = item.type().split("-");
        if (typeArgs.length < 2) {
            return false;
        }
        int index = this.parseIndex(typeArgs[1]);
        if (index < 0) {
            return false;
        }
        String caseType = typeArgs.length >= 3 ? typeArgs[2] : definition.settings().type();
        CaseDefinition historyCaseData = this.getHistoryDefinition(caseType, isGlobal = caseType.equalsIgnoreCase("GLOBAL"));
        if (historyCaseData == null && !isGlobal) {
            return false;
        }
        CaseData.History history = this.getHistoryData(caseType, isGlobal, globalHistoryData, index);
        if (history == null) {
            return false;
        }
        if (isGlobal) {
            historyCaseData = DCAPI.getInstance().getCaseManager().getByType(history.caseType()).orElse(null);
        }
        if (historyCaseData == null) {
            return false;
        }
        CaseItem historyItem = historyCaseData.items().getItem(history.item());
        if (historyItem == null) {
            return false;
        }
        this.applyMaterial(itemMaterial, history, historyItem);
        this.applyPlaceholders(itemMaterial, history, historyItem, historyCaseData);
        return true;
    }

    private int parseIndex(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    private CaseDefinition getHistoryDefinition(String caseType, boolean isGlobal) {
        if (isGlobal) {
            return null;
        }
        Optional<CaseDefinition> optional = DCAPI.getInstance().getCaseManager().getByType(caseType);
        return optional.map(CaseDefinition::clone).orElse(null);
    }

    private void applyMaterial(CaseMaterial itemMaterial, CaseData.History data, CaseItem historyItem) {
        String id = itemMaterial.id();
        String material = id == null ? "HEAD:" + data.playerName() : (id.equalsIgnoreCase("DEFAULT") ? historyItem.material().id() : id);
        itemMaterial.id(material);
    }

    private void applyPlaceholders(CaseMaterial itemMaterial, CaseData.History data, CaseItem historyItem, CaseDefinition caseDefinition) {
        Collection<LocalPlaceholder> placeholders = this.getPlaceholders(caseDefinition, data, historyItem);
        itemMaterial.displayName(DCTools.rt(itemMaterial.displayName(), placeholders));
        itemMaterial.lore(DCTools.rt(itemMaterial.lore(), placeholders));
    }

    private Collection<LocalPlaceholder> getPlaceholders(CaseDefinition caseDefinition, CaseData.History data, CaseItem historyItem) {
        String group = data.group();
        String groupDisplayName = data.item() != null ? historyItem.material().displayName() : "group_not_found";
        String action = Optional.ofNullable(data.action()).orElse(group);
        String actionDisplayName = this.getActionDisplayName(action, groupDisplayName, historyItem.randomActions());
        ArrayList<LocalPlaceholder> placeholders = new ArrayList<LocalPlaceholder>(LocalPlaceholder.of(data));
        placeholders.addAll(LocalPlaceholder.of(caseDefinition));
        placeholders.add(LocalPlaceholder.of("%actiondisplayname%", actionDisplayName));
        placeholders.add(LocalPlaceholder.of("%groupdisplayname%", groupDisplayName));
        return placeholders;
    }

    private String getActionDisplayName(String action, String fallback, Map<String, CaseItem.RandomAction> actions) {
        if (action == null || action.isEmpty()) {
            return fallback;
        }
        return Optional.ofNullable(actions.get(action)).map(CaseItem.RandomAction::displayName).orElse("random_action_not_found");
    }

    private CaseData.History getHistoryData(String caseType, boolean isGlobal, List<CaseData.History> globalHistoryData, int index) {
        if (isGlobal) {
            return index < globalHistoryData.size() ? globalHistoryData.get(index) : null;
        }
        List<CaseData.History> filtered = DCTools.sortHistoryDataByCase(globalHistoryData, caseType);
        return index < filtered.size() ? filtered.get(index) : null;
    }
}

