/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.managers;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.data.action.ActionException;
import com.jodexindustries.donatecase.api.data.action.CaseAction;
import com.jodexindustries.donatecase.api.manager.ActionManager;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.api.platform.Platform;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.common.actions.BroadcastActionExecutorImpl;
import com.jodexindustries.donatecase.common.actions.MessageActionExecutorImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionManagerImpl
implements ActionManager {
    public final Map<String, CaseAction> registeredActions = new ConcurrentHashMap<String, CaseAction>();
    private final DCAPI api;
    private final Platform platform;

    public ActionManagerImpl(DCAPI api) {
        this.api = api;
        this.platform = api.getPlatform();
        List<CaseAction> defaultActions = Arrays.asList(CaseAction.builder().name("[message]").addon(this.platform).executor(new MessageActionExecutorImpl()).description("Sends a message in the player's chat").build(), CaseAction.builder().name("[broadcast]").addon(this.platform).executor(new BroadcastActionExecutorImpl()).description("Sends a broadcast to the players").build());
        defaultActions.forEach(this::register);
    }

    @Override
    public void register(CaseAction action) throws ActionException {
        if (this.isRegistered(action.name())) {
            throw new ActionException("Action with name " + action.name() + " already registered!");
        }
        this.registeredActions.put(action.name(), action);
    }

    @Override
    public void unregister(@NotNull String name) throws ActionException {
        if (!this.isRegistered(name)) {
            throw new ActionException("Action with name " + name + " already unregistered!");
        }
        this.registeredActions.remove(name);
    }

    @Override
    public void unregister() {
        ArrayList<String> list = new ArrayList<String>(this.registeredActions.keySet());
        list.forEach(this::unregister);
    }

    @Override
    @NotNull
    public Map<String, CaseAction> getMap() {
        return this.registeredActions;
    }

    @Override
    public void execute(@Nullable DCPlayer player, @NotNull String action, int cooldown) {
        Optional<String> temp = this.getByStart(action);
        if (!temp.isPresent()) {
            return;
        }
        String context = action.replace(temp.get(), "").trim();
        Optional<CaseAction> caseAction = this.get(temp.get());
        if (!caseAction.isPresent()) {
            return;
        }
        this.platform.getScheduler().run((Addon)this.platform, () -> {
            try {
                ((CaseAction)caseAction.get()).execute(player, context);
            }
            catch (ActionException e) {
                this.platform.getLogger().log(Level.WARNING, "Error with executing action: " + context, e);
            }
        }, (long)cooldown);
    }

    @Override
    public void execute(@Nullable DCPlayer player, @NotNull List<String> actions) {
        for (String action : actions) {
            if (player != null) {
                action = DCTools.rc(this.api.getPlatform().getPAPI().setPlaceholders(player, action));
            }
            int cooldown = DCTools.extractCooldown(action);
            action = action.replaceFirst("\\[cooldown:(.*?)]", "");
            this.execute(player, action, cooldown);
        }
    }
}

