/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.managers;

import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.manager.CaseManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseManagerImpl
implements CaseManager {
    public final Map<String, CaseDefinition> caseDefinitionMap = new ConcurrentHashMap<String, CaseDefinition>();
    @Deprecated
    private static final Map<String, CaseData> caseDataMap = new ConcurrentHashMap<String, CaseData>();

    @Override
    public boolean hasByType(@NotNull String type) {
        return this.caseDefinitionMap.containsKey(type);
    }

    @Override
    @NotNull
    public Optional<CaseDefinition> getByType(@NotNull String type) {
        return Optional.ofNullable(this.caseDefinitionMap.get(type));
    }

    @Override
    @NotNull
    public Collection<CaseDefinition> definitions() {
        return Collections.unmodifiableCollection(this.caseDefinitionMap.values());
    }

    @Override
    @Deprecated
    @Nullable
    public CaseData get(@NotNull String type) {
        return caseDataMap.computeIfAbsent(type, key -> this.getByType((String)key).map(this::createFromDefinition).orElse(null));
    }

    @Override
    @Deprecated
    public Map<String, CaseData> getMap() {
        if (caseDataMap.size() != this.caseDefinitionMap.size()) {
            for (Map.Entry<String, CaseDefinition> entry : this.caseDefinitionMap.entrySet()) {
                caseDataMap.computeIfAbsent(entry.getKey(), key -> this.createFromDefinition((CaseDefinition)entry.getValue()));
            }
        }
        return caseDataMap;
    }

    @Deprecated
    @Nullable
    private CaseData createFromDefinition(@Nullable CaseDefinition definition) {
        if (definition == null) {
            return null;
        }
        return CaseData.fromDefinition(definition);
    }
}

