/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.managers;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.database.DatabaseStatus;
import com.jodexindustries.donatecase.api.data.database.DatabaseType;
import com.jodexindustries.donatecase.api.manager.CaseOpenManager;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class CaseOpenManagerImpl
extends CaseOpenManager {
    private final DCAPI api;

    public CaseOpenManagerImpl(DCAPI api) {
        this.api = api;
    }

    @Override
    public int get(String caseType, String player) {
        return this.getAsync(caseType, player).join();
    }

    @Override
    public Map<String, Integer> get(String player) {
        return this.getAsync(player).join();
    }

    @Override
    public CompletableFuture<Integer> getAsync(String caseType, String player) {
        return this.api.getDatabase().getOpenCount(player, caseType);
    }

    @Override
    public CompletableFuture<Map<String, Integer>> getAsync(String player) {
        return this.api.getDatabase().getOpenCount(player);
    }

    @Override
    public CompletableFuture<Map<String, Map<String, Integer>>> getGlobalAsync() {
        return this.api.getDatabase().getGlobalOpenCount();
    }

    @Override
    public CompletableFuture<Map<String, Integer>> getGlobalAsync(String caseType) {
        return this.api.getDatabase().getGlobalOpenCount(caseType);
    }

    @Override
    public int getCache(String caseType, String player) {
        Integer count = this.getCache(player).get(caseType);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    public Map<String, Integer> getCache(String player) {
        Map count;
        if (this.api.getDatabase().getType() == DatabaseType.SQLITE) {
            return this.get(player);
        }
        Map cachedCount = (Map)cache.get(player);
        if (cachedCount == null) {
            Map<String, Integer> previous = (Map<String, Integer>)cache.getPrevious(player);
            count = previous != null ? previous : this.get(player);
            this.getAsync(player).thenAcceptAsync(map -> cache.put(player, map));
        } else {
            count = cachedCount;
        }
        return count;
    }

    @Override
    public CompletableFuture<DatabaseStatus> set(String caseType, String player, int openCount) {
        return this.api.getDatabase().setCount(caseType, player, openCount);
    }

    @Override
    public CompletableFuture<DatabaseStatus> add(String caseType, String player, int openCount) {
        return this.getAsync(caseType, player).thenComposeAsync(integer -> this.set(caseType, player, integer + openCount));
    }
}

