/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.managers;

import com.jodexindustries.donatecase.api.data.casedata.gui.CaseGuiWrapper;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMenu;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.manager.GUIManager;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.common.DonateCase;
import com.jodexindustries.donatecase.common.platform.BackendPlatform;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class GUIManagerImpl
implements GUIManager {
    public final Map<UUID, CaseGuiWrapper> playersGui = new ConcurrentHashMap<UUID, CaseGuiWrapper>();
    private final DonateCase api;
    private final BackendPlatform platform;

    public GUIManagerImpl(DonateCase api) {
        this.api = api;
        this.platform = api.getPlatform();
    }

    @Override
    public void open(@NotNull DCPlayer player, @NotNull String caseType, @NotNull String menuId, @NotNull CaseLocation location) {
        Optional<CaseDefinition> optional = this.api.getCaseManager().getByType(caseType);
        if (!optional.isPresent()) {
            this.platform.getLogger().warning("Player '" + player.getName() + "' attempted to open a non-existent case type: '" + caseType + "'.");
            return;
        }
        this.open(player, optional.get(), menuId, location);
    }

    @Override
    public void open(@NotNull DCPlayer player, @NotNull CaseDefinition caseDefinition, @NotNull String menuId, @NotNull CaseLocation location) {
        Optional<CaseMenu> optionalMenu = caseDefinition.getMenuById(menuId);
        if (!optionalMenu.isPresent()) {
            this.platform.getLogger().warning("Player '" + player.getName() + "' attempted to open case type '" + caseDefinition.settings().type() + "' with missing or undefined GUI (menu ID: '" + menuId + "').");
            return;
        }
        this.open(player, caseDefinition, optionalMenu.get(), location);
    }

    @Override
    public void open(@NotNull DCPlayer player, @NotNull CaseDefinition caseDefinition, @NotNull CaseMenu menu, @NotNull CaseLocation location) {
        if (this.playersGui.containsKey(player.getUniqueId())) {
            this.platform.getLogger().fine("Player '" + player.getName() + "' already has an open GUI. Skipping duplicate open.");
            return;
        }
        this.playersGui.put(player.getUniqueId(), this.platform.createGui(player, caseDefinition, menu, location));
    }

    @Override
    public Map<UUID, CaseGuiWrapper> getMap() {
        return this.playersGui;
    }
}

