/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.managers;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.material.CaseMaterial;
import com.jodexindustries.donatecase.api.data.material.CaseMaterialException;
import com.jodexindustries.donatecase.api.manager.MaterialManager;
import com.jodexindustries.donatecase.api.platform.Platform;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialManagerImpl
implements MaterialManager {
    public final Map<String, CaseMaterial> registeredMaterials = new ConcurrentHashMap<String, CaseMaterial>();
    private final Platform platform;

    public MaterialManagerImpl(DCAPI api) {
        this.platform = api.getPlatform();
    }

    @Override
    public void register(CaseMaterial material) throws CaseMaterialException {
        if (this.isRegistered(material.id())) {
            throw new CaseMaterialException("Material with id " + material.id() + " already registered!");
        }
        this.registeredMaterials.put(material.id(), material);
    }

    @Override
    public void unregister(String id) {
        if (this.isRegistered(id)) {
            this.registeredMaterials.remove(id);
        } else {
            this.platform.getLogger().warning("CaseMaterial with id " + id + " already unregistered!");
        }
    }

    @Override
    public void unregister() {
        ArrayList<String> list = new ArrayList<String>(this.registeredMaterials.keySet());
        list.forEach(this::unregister);
    }

    @Override
    public boolean isRegistered(String id) {
        return this.registeredMaterials.containsKey(id);
    }

    @Override
    @Nullable
    public CaseMaterial get(@NotNull String id) {
        return this.registeredMaterials.get(id);
    }

    @Override
    @NotNull
    public Map<String, CaseMaterial> getMap() {
        return this.registeredMaterials;
    }
}

