/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.tools.updater;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.common.DonateCase;
import com.jodexindustries.donatecase.common.tools.updater.VersionInfo;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;

public class UpdateChecker {
    private final DonateCase api;

    public UpdateChecker(DonateCase api) {
        this.api = api;
    }

    public void check() {
        this.getVersion().thenAcceptAsync(version -> {
            if (version.isNew()) {
                this.api.getPlatform().getLogger().info("There is a new update " + version.getVersionNumber() + " available.");
                this.api.getPlatform().getLogger().info("Download - https://modrinth.com/plugin/donatecase");
            }
        });
    }

    public CompletableFuture<VersionInfo> getVersion() {
        return !this.api.getConfigManager().getConfig().updateChecker() ? CompletableFuture.completedFuture(new VersionInfo()) : CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/donatecase/version?featured=true");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Accept", "application/json");
                if (connection.getResponseCode() == 200) {
                    return this.getLatest(connection);
                }
                this.api.getPlatform().getLogger().warning("Unable to check for updates. HTTP response code: " + connection.getResponseCode());
            }
            catch (Exception exception) {
                this.api.getPlatform().getLogger().warning("Unable to check for updates: " + exception.getMessage());
            }
            return null;
        });
    }

    private VersionInfo getLatest(HttpURLConnection connection) throws IOException {
        JsonArray versions;
        Gson gson = new Gson();
        try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
            versions = JsonParser.parseReader((Reader)reader).getAsJsonArray();
        }
        VersionInfo latestVersionInfo = null;
        for (JsonElement versionElement : versions) {
            JsonObject versionObject = versionElement.getAsJsonObject();
            VersionInfo versionInfo = (VersionInfo)gson.fromJson((JsonElement)versionObject, VersionInfo.class);
            if (latestVersionInfo != null && versionInfo.getDatePublished().compareTo(latestVersionInfo.getDatePublished()) <= 0) continue;
            latestVersionInfo = versionInfo;
        }
        if (latestVersionInfo != null && DCTools.getPluginVersion(this.api.getPlatform().getVersion()) < DCTools.getPluginVersion(latestVersionInfo.getVersionNumber())) {
            latestVersionInfo.setNew(true);
        }
        return latestVersionInfo;
    }
}

