/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.animations.pop;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.armorstand.ArmorStandCreator;
import com.jodexindustries.donatecase.api.data.animation.Facing;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.scheduler.SchedulerTask;
import com.jodexindustries.donatecase.spigot.animations.pop.PopSettings;
import com.jodexindustries.donatecase.spigot.api.animation.BukkitJavaAnimation;
import com.jodexindustries.donatecase.spigot.tools.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.spongepowered.configurate.serialize.SerializationException;

public class PopAnimation
extends BukkitJavaAnimation {
    private static final DCAPI api = DCAPI.getInstance();
    private PopSettings settings;

    @Override
    public void start() {
        try {
            this.settings = (PopSettings)this.getSettings().get(PopSettings.class);
        }
        catch (SerializationException e) {
            throw new RuntimeException("Error with parsing animation settings", e);
        }
        ArrayList<Pair<ArmorStandCreator, CaseLocation>> asList = new ArrayList<Pair<ArmorStandCreator, CaseLocation>>();
        double origX = this.getLocation().x() + 0.5;
        double origY = this.getLocation().y() - 0.5;
        double origZ = this.getLocation().z() + 0.5;
        CaseLocation origCaseLocation = this.getLocation().clone().x(origX).y(origY).z(origZ);
        for (double y = -1.0; y < 2.0; y += 1.0) {
            for (double horOffset = -1.0; horOffset < 2.0; horOffset += 1.0) {
                double horizonOffset;
                if (y == 0.0 && horOffset == 0.0) continue;
                this.getLocation().y(origY + (this.settings.rounded ? y / 1.4142 : y));
                double d = this.settings.rounded ? horOffset * (y == 0.0 ? 1.0 : 0.707) : (horizonOffset = horOffset);
                if (this.settings.facing == Facing.EAST || this.settings.facing == Facing.WEST) {
                    this.getLocation().z(origZ + horizonOffset);
                } else {
                    this.getLocation().x(origX + horizonOffset);
                }
                ArmorStandCreator as = DCAPI.getInstance().getPlatform().getTools().createArmorStand(this.getUuid(), this.getLocation());
                as.setVisible(false);
                as.setGravity(false);
                as.setSmall(true);
                as.teleport(origCaseLocation);
                as.spawn();
                double yOffset = origY + (this.settings.rounded ? y / (horOffset == 0.0 ? 1.0 : 1.4142) : y) * this.settings.radius;
                if (this.settings.facing == Facing.EAST || this.settings.facing == Facing.WEST) {
                    asList.add(Pair.of(as, as.getLocation().clone().x(origX).y(yOffset).z(origZ + horizonOffset * this.settings.radius)));
                    continue;
                }
                asList.add(Pair.of(as, as.getLocation().clone().x(origX + horizonOffset * this.settings.radius).y(yOffset).z(origZ)));
            }
        }
        api.getPlatform().getScheduler().run((Addon)api.getPlatform(), new Task(asList, origCaseLocation), 0L, (long)this.settings.period);
    }

    private class Task
    implements Consumer<SchedulerTask> {
        private int tick;
        private final CaseLocation location;
        private final List<Pair<ArmorStandCreator, CaseLocation>> asList;
        private final World world;
        private final List<Integer> indexes = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7));
        private int randomIndex;

        public Task(List<Pair<ArmorStandCreator, CaseLocation>> asList, CaseLocation location) {
            this.asList = asList;
            this.location = location;
            this.world = PopAnimation.this.getPlayer().getWorld();
        }

        @Override
        public void accept(SchedulerTask task) {
            ArmorStandCreator as;
            if (this.tick == 0) {
                this.alignArmorStands();
            }
            if (this.tick == 10) {
                this.fillStandItem();
            }
            if (this.tick == 10) {
                for (Pair<ArmorStandCreator, CaseLocation> pair : this.asList) {
                    ArmorStandCreator as2 = (ArmorStandCreator)pair.fst;
                    CaseLocation target = (CaseLocation)pair.snd;
                    as2.teleport(target);
                }
            }
            if (this.tick >= 30 && this.tick % 15 == 0 && this.tick <= 129) {
                this.handleRemoveLogic();
            }
            if (this.tick == 129) {
                as = (ArmorStandCreator)this.asList.get((int)this.randomIndex).fst;
                this.location.x(as.getLocation().x());
                this.location.y(as.getLocation().y());
                this.location.z(as.getLocation().z());
                this.location.yaw(as.getLocation().yaw());
                PopAnimation.this.preEnd();
            }
            if (this.tick >= 129) {
                as = (ArmorStandCreator)this.asList.get((int)this.randomIndex).fst;
                this.location.yaw(this.location.yaw() + 15.0f);
                as.teleport(this.location);
            }
            if (this.tick >= 170) {
                this.cleanup(task);
            }
            ++this.tick;
        }

        public void handleRemoveLogic() {
            Random random = new Random();
            int randomIndex = random.nextInt(this.indexes.size());
            int initialIndex = this.indexes.get(randomIndex);
            ArmorStandCreator as = (ArmorStandCreator)this.asList.get((int)initialIndex).fst;
            Location bukkitLocation = new Location(this.world, as.getLocation().x(), as.getLocation().y() + 1.0, as.getLocation().z());
            this.world.spawnParticle(Particle.CLOUD, bukkitLocation, 0);
            as.remove();
            this.indexes.remove(randomIndex);
            Sound sound = ((PopAnimation)PopAnimation.this).settings.scroll.sound();
            if (sound != null) {
                this.world.playSound(bukkitLocation, sound, ((PopAnimation)PopAnimation.this).settings.scroll.volume, ((PopAnimation)PopAnimation.this).settings.scroll.pitch);
            }
        }

        private void alignArmorStands() {
            for (Pair<ArmorStandCreator, CaseLocation> pair : this.asList) {
                ((ArmorStandCreator)pair.fst).teleport(this.location.yaw(((PopAnimation)PopAnimation.this).settings.facing.yaw));
            }
        }

        private void fillStandItem() {
            Random random = new Random();
            this.randomIndex = random.nextInt(8);
            Pair<ArmorStandCreator, CaseLocation> win = this.asList.get(this.randomIndex);
            this.indexes.remove(this.randomIndex);
            ((ArmorStandCreator)win.fst).setEquipment(((PopAnimation)PopAnimation.this).settings.itemSlot, PopAnimation.this.getItem().material().itemStack());
            if (PopAnimation.this.getItem().material().displayName() != null && !PopAnimation.this.getItem().material().displayName().isEmpty()) {
                ((ArmorStandCreator)win.fst).setCustomNameVisible(true);
            }
            ((ArmorStandCreator)win.fst).setCustomName(api.getPlatform().getPAPI().setPlaceholders(PopAnimation.this.getPlayer(), PopAnimation.this.getItem().material().displayName()));
            ((ArmorStandCreator)win.fst).updateMeta();
            for (int i = 0; i < 8; ++i) {
                if (i == this.randomIndex) continue;
                Pair<ArmorStandCreator, CaseLocation> pair = this.asList.get(i);
                ArmorStandCreator as = (ArmorStandCreator)pair.fst;
                CaseItem item = PopAnimation.this.getDefinition().items().getRandomItem();
                as.setEquipment(((PopAnimation)PopAnimation.this).settings.itemSlot, item.material().itemStack());
                String winGroupDisplayName = api.getPlatform().getPAPI().setPlaceholders(PopAnimation.this.getPlayer(), item.material().displayName());
                if (item.material().displayName() != null && !item.material().displayName().isEmpty()) {
                    as.setCustomNameVisible(true);
                }
                as.setCustomName(winGroupDisplayName);
                as.updateMeta();
            }
        }

        private void cleanup(SchedulerTask task) {
            this.asList.forEach(pair -> ((ArmorStandCreator)pair.fst).remove());
            task.cancel();
            PopAnimation.this.end();
        }
    }
}

