/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.animations.select;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.armorstand.ArmorStandCreator;
import com.jodexindustries.donatecase.api.data.animation.Facing;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.scheduler.SchedulerTask;
import com.jodexindustries.donatecase.spigot.animations.select.SelectSettings;
import com.jodexindustries.donatecase.spigot.api.animation.BukkitJavaAnimation;
import com.jodexindustries.donatecase.spigot.tools.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.serialize.SerializationException;

public class SelectAnimation
extends BukkitJavaAnimation {
    private static final DCAPI api = DCAPI.getInstance();
    private Task task;
    @NotNull
    public SelectSettings settings = new SelectSettings();

    @Override
    public void start() {
        try {
            this.settings = (SelectSettings)this.getSettings().get(SelectSettings.class, (Object)new SelectSettings());
        }
        catch (SerializationException e) {
            throw new RuntimeException("Error with parsing animation settings", e);
        }
        ArrayList<Pair<ArmorStandCreator, CaseLocation>> asList = new ArrayList<Pair<ArmorStandCreator, CaseLocation>>();
        double origX = this.getLocation().x() + 0.5;
        double origY = this.getLocation().y() - 0.5;
        double origZ = this.getLocation().z() + 0.5;
        CaseLocation origCaseLocation = this.getLocation().clone().x(origX).y(origY).z(origZ);
        for (double y = -1.0; y < 2.0; y += 1.0) {
            for (double horizonOffset = -1.0; horizonOffset < 2.0; horizonOffset += 1.0) {
                if (y == 0.0 && horizonOffset == 0.0) continue;
                this.getLocation().y(origY + y);
                if (this.settings.facing == Facing.EAST || this.settings.facing == Facing.WEST) {
                    this.getLocation().z(origZ + horizonOffset);
                } else {
                    this.getLocation().x(origX + horizonOffset);
                }
                ArmorStandCreator as = api.getPlatform().getTools().createArmorStand(this.getUuid(), this.getLocation());
                as.setVisible(false);
                as.setGravity(false);
                as.setSmall(true);
                as.teleport(origCaseLocation);
                as.spawn();
                if (this.settings.facing == Facing.EAST || this.settings.facing == Facing.WEST) {
                    asList.add(Pair.of(as, as.getLocation().clone().x(origX).y(origY + y * this.settings.radius).z(origZ + horizonOffset * this.settings.radius)));
                    continue;
                }
                asList.add(Pair.of(as, as.getLocation().clone().x(origX + horizonOffset * this.settings.radius).y(origY + y * this.settings.radius).z(origZ)));
            }
        }
        this.task = new Task(asList, origCaseLocation);
        api.getPlatform().getScheduler().run((Addon)api.getPlatform(), this.task, 0L, (long)this.settings.period);
    }

    @Generated
    public Task getTask() {
        return this.task;
    }

    public class Task
    implements Consumer<SchedulerTask> {
        private int tick;
        private final CaseLocation location;
        private final List<Pair<ArmorStandCreator, CaseLocation>> asList;
        private final World world;
        public boolean canSelect = false;
        public volatile boolean selected = false;
        private Pair<ArmorStandCreator, CaseLocation> randomAS;
        private final List<ArmorStandCreator> toDelete = new ArrayList<ArmorStandCreator>();

        public Task(List<Pair<ArmorStandCreator, CaseLocation>> asList, CaseLocation location) {
            this.asList = asList;
            this.location = location;
            this.world = SelectAnimation.this.getPlayer().getWorld();
        }

        @Override
        public void accept(SchedulerTask task) {
            if (this.tick == 0) {
                for (Pair<ArmorStandCreator, CaseLocation> pair : this.asList) {
                    ArmorStandCreator as = (ArmorStandCreator)pair.fst;
                    this.location.yaw(SelectAnimation.this.settings.facing.yaw);
                    as.teleport(this.location);
                }
            }
            if (this.tick >= 10 && this.tick < 90) {
                if (this.tick % 10 == 0 && !this.asList.isEmpty()) {
                    Random random = new Random();
                    int index = random.nextInt(this.asList.size());
                    this.randomAS = this.asList.get(index);
                    this.asList.remove(index);
                    this.toDelete.add((ArmorStandCreator)this.randomAS.fst);
                }
                if (this.randomAS != null) {
                    ArmorStandCreator as = (ArmorStandCreator)this.randomAS.fst;
                    CaseLocation needLocation = (CaseLocation)this.randomAS.snd;
                    as.setEquipment(SelectAnimation.this.settings.itemSlot, api.getPlatform().getTools().loadCaseItem(SelectAnimation.this.settings.item));
                    as.updateMeta();
                    CaseLocation currentLocation = as.getLocation().clone();
                    double deltaX = needLocation.x() - currentLocation.x();
                    double deltaY = needLocation.y() - currentLocation.y();
                    double deltaZ = needLocation.z() - currentLocation.z();
                    double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
                    double step = distance / 10.0;
                    double moveX = deltaX * (step / distance);
                    double moveY = deltaY * (step / distance);
                    double moveZ = deltaZ * (step / distance);
                    as.teleport(currentLocation.add(moveX, moveY, moveZ));
                    Location bukkitLocation = new Location(this.world, as.getLocation().x(), as.getLocation().y() + 1.0, as.getLocation().z());
                    this.world.spawnParticle(Particle.CLOUD, bukkitLocation, 0);
                }
            }
            if (this.tick == 91) {
                this.canSelect = true;
            }
            if (this.tick > 91 && this.selected) {
                task.cancel();
                api.getPlatform().getScheduler().run((Addon)api.getPlatform(), this::end, 40L);
            }
            if (this.tick >= SelectAnimation.this.settings.timeout) {
                task.cancel();
                this.end();
            }
            ++this.tick;
        }

        private void end() {
            SelectAnimation.super.preEnd();
            for (ArmorStandCreator as : this.toDelete) {
                as.remove();
            }
            SelectAnimation.super.end();
        }
    }
}

