/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.animations.wheel;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.armorstand.ArmorStandCreator;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMaterial;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.data.storage.CaseVector;
import com.jodexindustries.donatecase.api.scheduler.SchedulerTask;
import com.jodexindustries.donatecase.spigot.animations.wheel.WheelSettings;
import com.jodexindustries.donatecase.spigot.api.animation.BukkitJavaAnimation;
import com.jodexindustries.donatecase.spigot.tools.BukkitUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.spongepowered.configurate.serialize.SerializationException;

public class WheelAnimation
extends BukkitJavaAnimation {
    private static final DCAPI api = DCAPI.getInstance();
    private final List<ArmorStandCreator> armorStands = new ArrayList<ArmorStandCreator>();
    private WheelSettings settings;

    @Override
    public void start() {
        try {
            this.settings = (WheelSettings)this.getSettings().get(WheelSettings.class);
        }
        catch (SerializationException e) {
            throw new RuntimeException("Error with parsing animation settings", e);
        }
        api.getPlatform().getScheduler().run((Addon)api.getPlatform(), new Task(), 0L, 0L);
    }

    private ArmorStandCreator spawnArmorStand(CaseLocation location, CaseItem item, boolean small) {
        CaseMaterial material = item.material();
        ArmorStandCreator as = api.getPlatform().getTools().createArmorStand(this.getUuid(), location);
        as.setSmall(small);
        as.setVisible(false);
        as.setGravity(false);
        if (this.settings.armorStandEulerAngle != null) {
            as.setAngle(this.settings.armorStandEulerAngle);
        }
        as.setCustomName(api.getPlatform().getPAPI().setPlaceholders(this.getPlayer(), item.material().displayName()));
        as.setCustomNameVisible(item.material().displayName() != null && !item.material().displayName().isEmpty());
        as.spawn();
        as.setEquipment(this.settings.itemSlot, material.itemStack());
        return as;
    }

    private class Task
    implements Consumer<SchedulerTask> {
        private final CaseLocation location;
        private final Location bukkitLocation;
        private final World world;
        private final double baseAngle;
        private double lastCompletedRotation;
        private int ticks;
        private double targetAngle;
        private final double rotationThreshold;
        private final double offset;

        public Task() {
            float yaw;
            this.location = WheelAnimation.this.getLocation().clone();
            this.lastCompletedRotation = 0.0;
            float pitch = ((WheelAnimation)WheelAnimation.this).settings.facing == null ? (float)Math.round(this.location.pitch() / 45.0f) * 45.0f : ((WheelAnimation)WheelAnimation.this).settings.facing.pitch;
            float f = yaw = ((WheelAnimation)WheelAnimation.this).settings.facing == null ? (float)Math.round(this.location.yaw() / 45.0f) * 45.0f : ((WheelAnimation)WheelAnimation.this).settings.facing.yaw;
            if (((WheelAnimation)WheelAnimation.this).settings.startPosition != null) {
                this.location.add(((WheelAnimation)WheelAnimation.this).settings.startPosition);
            }
            this.location.pitch(pitch);
            this.location.yaw(yaw);
            this.baseAngle = this.location.clone().getDirection().angle(new CaseVector(0, 0, 1));
            this.initializeItems();
            this.rotationThreshold = Math.PI / (double)WheelAnimation.this.armorStands.size();
            this.offset = 2.0 * this.rotationThreshold;
            this.world = WheelAnimation.this.getPlayer().getWorld();
            this.bukkitLocation = BukkitUtils.toBukkit(this.location);
        }

        @Override
        public void accept(SchedulerTask task) {
            ++this.ticks;
            double progress = Math.min((double)this.ticks / (double)((WheelAnimation)WheelAnimation.this).settings.scroll.time, 1.0);
            double easedProgress = 1.0 - Math.pow(1.0 - progress, ((WheelAnimation)WheelAnimation.this).settings.scroll.easeAmount);
            double currentAngle = easedProgress * this.targetAngle;
            if (this.ticks <= ((WheelAnimation)WheelAnimation.this).settings.scroll.time) {
                this.handleFlameEffects();
                this.moveArmorStands(currentAngle);
            }
            if (this.ticks == ((WheelAnimation)WheelAnimation.this).settings.scroll.time) {
                WheelAnimation.this.preEnd();
            }
            if (this.ticks >= ((WheelAnimation)WheelAnimation.this).settings.scroll.time + 20) {
                this.endAnimation(task);
            }
        }

        private void initializeItems() {
            if (((WheelAnimation)WheelAnimation.this).settings.wheelType == WheelSettings.WheelType.FULL) {
                ArrayList<CaseItem> uniqueItems = new ArrayList<CaseItem>(WheelAnimation.this.getDefinition().items().items().values());
                if (((WheelAnimation)WheelAnimation.this).settings.shuffle) {
                    Collections.shuffle(uniqueItems);
                }
                int additionalSteps = 0;
                for (CaseItem uniqueItem : uniqueItems) {
                    if (uniqueItem.name().equals(WheelAnimation.this.getItem().name())) {
                        additionalSteps = uniqueItems.size() - WheelAnimation.this.armorStands.size();
                        WheelAnimation.this.armorStands.add(WheelAnimation.this.spawnArmorStand(this.location, WheelAnimation.this.getItem(), ((WheelAnimation)WheelAnimation.this).settings.smallArmorStand));
                        continue;
                    }
                    WheelAnimation.this.armorStands.add(WheelAnimation.this.spawnArmorStand(this.location, uniqueItem, ((WheelAnimation)WheelAnimation.this).settings.smallArmorStand));
                }
                double additionalAngle = (double)additionalSteps * (Math.PI * 2 / (double)WheelAnimation.this.armorStands.size());
                this.targetAngle = Math.PI * 2 * (double)((WheelAnimation)WheelAnimation.this).settings.scroll.count + additionalAngle;
            } else {
                WheelAnimation.this.armorStands.add(WheelAnimation.this.spawnArmorStand(this.location, WheelAnimation.this.getItem(), ((WheelAnimation)WheelAnimation.this).settings.smallArmorStand));
                for (int i = 1; i < ((WheelAnimation)WheelAnimation.this).settings.itemsCount; ++i) {
                    CaseItem randomItem = WheelAnimation.this.getDefinition().items().getRandomItem();
                    WheelAnimation.this.armorStands.add(WheelAnimation.this.spawnArmorStand(this.location, randomItem, ((WheelAnimation)WheelAnimation.this).settings.smallArmorStand));
                }
                int rand = new Random().nextInt(WheelAnimation.this.armorStands.size());
                int additionalSteps = WheelAnimation.this.armorStands.size() - rand;
                double additionalAngle = (double)additionalSteps * (Math.PI * 2 / (double)WheelAnimation.this.armorStands.size());
                this.targetAngle = Math.PI * 2 * (double)((WheelAnimation)WheelAnimation.this).settings.scroll.count + additionalAngle;
                Collections.swap(WheelAnimation.this.armorStands, 0, rand);
            }
        }

        private void handleFlameEffects() {
            if (((WheelAnimation)WheelAnimation.this).settings.flame.enabled) {
                double progress = Math.min((double)this.ticks / (double)((WheelAnimation)WheelAnimation.this).settings.scroll.time * 0.9, 1.0);
                double easedProgress = 1.0 - Math.pow(1.0 - progress, ((WheelAnimation)WheelAnimation.this).settings.scroll.easeAmount);
                double deltaX = Math.max((1.0 - easedProgress) * ((WheelAnimation)WheelAnimation.this).settings.radius, 0.4);
                double deltaY = easedProgress * ((WheelAnimation)WheelAnimation.this).settings.radius + 0.7;
                double theta = (double)this.ticks / 6.666666666666667;
                this.spawnFlameEffect(deltaX, deltaY, theta);
                this.spawnFlameEffect(deltaX, deltaY, theta + Math.PI);
            }
        }

        private void spawnFlameEffect(double deltaX, double deltaY, double theta) {
            double dx = deltaX * Math.sin(theta);
            double dz = deltaX * Math.cos(theta);
            this.world.spawnParticle(((WheelAnimation)WheelAnimation.this).settings.flame.particle, this.bukkitLocation.clone().add(dx, deltaY, dz), 1, 0.0, 0.0, 0.0, 0.0, null);
        }

        private void moveArmorStands(double angle) {
            for (ArmorStandCreator entity : WheelAnimation.this.armorStands) {
                Sound sound;
                double x = ((WheelAnimation)WheelAnimation.this).settings.radius * Math.sin(angle);
                double y = ((WheelAnimation)WheelAnimation.this).settings.radius * Math.cos(angle);
                CaseVector rotationAxis = this.location.getDirection().crossProduct(new CaseVector(0, 1, 0)).normalize();
                CaseLocation newLoc = this.location.clone().add(rotationAxis.multiply(x).add(this.location.getDirection().multiply(y)));
                entity.teleport(newLoc);
                double currentAngle = (angle += this.offset) - this.baseAngle;
                if (!(currentAngle - this.lastCompletedRotation >= this.rotationThreshold) || (sound = ((WheelAnimation)WheelAnimation.this).settings.scroll.sound()) == null) continue;
                this.world.playSound(this.bukkitLocation, sound, ((WheelAnimation)WheelAnimation.this).settings.scroll.volume, ((WheelAnimation)WheelAnimation.this).settings.scroll.pitch);
                this.lastCompletedRotation = currentAngle;
            }
        }

        private void endAnimation(SchedulerTask task) {
            task.cancel();
            for (ArmorStandCreator stand : WheelAnimation.this.armorStands) {
                stand.remove();
            }
            WheelAnimation.this.end();
            WheelAnimation.this.armorStands.clear();
        }
    }
}

