/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.api.platform;

import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.data.storage.CaseWorld;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.spigot.api.platform.BukkitCommandSender;
import com.jodexindustries.donatecase.spigot.tools.BukkitUtils;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class BukkitPlayer
extends BukkitCommandSender
implements DCPlayer {
    private final Player player;

    public BukkitPlayer(@NotNull Player player) {
        super((CommandSender)player);
        this.player = player;
    }

    @NotNull
    public Player getHandler() {
        return this.player;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public CaseWorld getWorld() {
        return BukkitUtils.fromBukkit(this.player.getWorld());
    }

    @Override
    public CaseLocation getLocation() {
        return BukkitUtils.fromBukkit(this.player.getLocation());
    }

    @Override
    public CaseLocation getTargetBlock(int maxDistance) {
        return BukkitUtils.fromBukkit(this.player.getTargetBlock(null, maxDistance).getLocation());
    }

    @Override
    public void openInventory(Object inventory) {
        this.player.openInventory((Inventory)inventory);
    }

    @Override
    public void closeInventory() {
        this.player.closeInventory();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        BukkitPlayer that = (BukkitPlayer)object;
        return Objects.equals(this.player, that.player);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.player);
    }
}

