/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.holograms;

import com.jodexindustries.donatecase.api.data.casedefinition.CaseSettings;
import com.jodexindustries.donatecase.api.data.hologram.HologramDriver;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.spigot.tools.BukkitUtils;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;

public class DecentHologramsImpl
implements HologramDriver {
    private final HashMap<CaseLocation, Hologram> holograms = new HashMap();

    @Override
    public void create(CaseLocation block, CaseSettings.Hologram caseHologram) {
        if (!caseHologram.enabled()) {
            return;
        }
        double height = caseHologram.height();
        Hologram hologram = DHAPI.createHologram((String)("DonateCase-" + UUID.randomUUID()), (Location)BukkitUtils.toBukkit(block).add(0.5, height, 0.5));
        hologram.setDisplayRange(caseHologram.range());
        caseHologram.message().forEach(line -> DHAPI.addHologramLine((Hologram)hologram, (String)DCTools.rc(line)));
        this.holograms.put(block, hologram);
    }

    @Override
    public void remove(CaseLocation block) {
        if (!this.holograms.containsKey(block)) {
            return;
        }
        Hologram hologram = this.holograms.get(block);
        this.holograms.remove(block);
        hologram.delete();
    }

    @Override
    public void remove() {
        this.holograms.values().forEach(Hologram::delete);
        this.holograms.clear();
    }
}

