/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.holograms;

import com.jodexindustries.donatecase.api.data.casedefinition.CaseSettings;
import com.jodexindustries.donatecase.api.data.hologram.HologramDriver;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.spigot.serializer.ConfigurationSectionImpl;
import com.jodexindustries.donatecase.spigot.tools.BukkitUtils;
import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.HologramManager;
import de.oliver.fancyholograms.api.data.BlockHologramData;
import de.oliver.fancyholograms.api.data.DisplayHologramData;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.ItemHologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.api.hologram.HologramType;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;

public class FancyHologramsImpl
implements HologramDriver {
    private final HologramManager manager = FancyHologramsPlugin.get().getHologramManager();
    private final HashMap<CaseLocation, Hologram> holograms = new HashMap();

    @Override
    public void create(CaseLocation block, CaseSettings.Hologram caseHologram) {
        ConfigurationNode node = caseHologram.node();
        HologramType type = HologramType.getByName((String)node.node(new Object[]{"type"}).getString());
        if (type == null) {
            return;
        }
        Location location = BukkitUtils.toBukkit(block).add(0.5, caseHologram.height(), 0.5);
        String name = "DonateCase-" + UUID.randomUUID();
        DisplayHologramData hologramData = FancyHologramsImpl.getData(type, name, location);
        hologramData.read((ConfigurationSection)new ConfigurationSectionImpl(node), name);
        Location tempLocation = hologramData.getLocation();
        if (tempLocation.getYaw() != 0.0f) {
            location.setYaw(tempLocation.getYaw());
        }
        if (tempLocation.getPitch() != 0.0f) {
            location.setPitch(tempLocation.getPitch());
        }
        hologramData.setLocation(location);
        Hologram hologram = this.manager.create((HologramData)hologramData);
        this.holograms.put(block, hologram);
        this.manager.addHologram(hologram);
    }

    @Override
    public void remove(CaseLocation block) {
        Hologram hologram = this.holograms.get(block);
        if (hologram == null) {
            return;
        }
        this.holograms.remove(block);
        this.manager.removeHologram(hologram);
    }

    @Override
    public void remove() {
        for (Hologram hologram : this.holograms.values()) {
            this.manager.removeHologram(hologram);
        }
        this.holograms.clear();
    }

    @NotNull
    private static DisplayHologramData getData(HologramType type, String name, Location location) {
        BlockHologramData hologramData;
        switch (type) {
            case BLOCK: {
                hologramData = new BlockHologramData(name, location);
                break;
            }
            case ITEM: {
                hologramData = new ItemHologramData(name, location);
                break;
            }
            case TEXT: {
                hologramData = new TextHologramData(name, location);
                break;
            }
            default: {
                hologramData = new DisplayHologramData(name, type, location);
            }
        }
        return hologramData;
    }
}

