/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.hook.packetevents;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.jodexindustries.donatecase.spigot.BukkitBackend;
import com.jodexindustries.donatecase.spigot.hook.packetevents.PacketEventsPacketListener;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import lombok.Generated;
import org.bukkit.plugin.Plugin;

public class PacketEventsSupport {
    private final PacketEventsAPI<?> api = PacketEvents.getAPI();
    private final PacketEventsPacketListener listener = new PacketEventsPacketListener();
    private final BukkitBackend backend;
    private boolean usePackets;

    public PacketEventsSupport(BukkitBackend backend) {
        this.backend = backend;
        this.usePackets = backend.getAPI().getConfigManager().getConfig().usePackets();
        this.load();
    }

    public void load() {
        if (this.usePackets) {
            this.backend.getLogger().info("Loading packetevents hooking...");
            PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this.backend.getPlugin()));
            this.api.getEventManager().registerListener((PacketListener)this.listener, PacketListenerPriority.NORMAL);
            if (this.api.isLoaded()) {
                this.backend.getLogger().info("Hooked to packetevents");
                this.usePackets = true;
            } else {
                this.usePackets = false;
            }
        }
    }

    public void unload() {
        this.api.terminate();
    }

    @Generated
    public boolean isUsePackets() {
        return this.usePackets;
    }
}

