/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.hook.papi;

import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.spigot.BukkitBackend;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class DonateCaseExpansion
extends PlaceholderExpansion {
    private final BukkitBackend backend;

    public DonateCaseExpansion(BukkitBackend backend) {
        this.backend = backend;
    }

    @NotNull
    public String getAuthor() {
        return "JodexIndustries";
    }

    @NotNull
    public String getIdentifier() {
        return this.backend.getName();
    }

    @NotNull
    public String getVersion() {
        return this.backend.getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (params.startsWith("keys")) {
            return this.processKeys(params, player);
        }
        if (params.startsWith("open_count")) {
            return this.processOpenCount(params, player);
        }
        if (params.startsWith("history_")) {
            return this.processHistory(params.replaceFirst("history_", ""));
        }
        return null;
    }

    private String processKeys(@NotNull String params, OfflinePlayer player) {
        String[] parts;
        if (params.startsWith("keys")) {
            parts = params.split("_", 2);
            Map<String, Integer> map = this.backend.getAPI().getCaseKeyManager().getCache(player.getName());
            int keys = map.values().stream().mapToInt(key -> key).sum();
            if (parts.length == 1) {
                return String.valueOf(keys);
            }
            if (parts[1].equalsIgnoreCase("format")) {
                return NumberFormat.getNumberInstance().format(keys);
            }
        }
        if (params.startsWith("keys_")) {
            parts = params.split("_", 3);
            int keys = this.backend.getAPI().getCaseKeyManager().getCache(parts[1], player.getName());
            if (parts.length == 2) {
                return String.valueOf(keys);
            }
            if (parts[2].equalsIgnoreCase("format")) {
                return NumberFormat.getNumberInstance().format(keys);
            }
            return String.valueOf(keys);
        }
        return null;
    }

    private String processOpenCount(@NotNull String params, OfflinePlayer player) {
        if (params.startsWith("open_count")) {
            String[] parts = params.split("_", 3);
            Map<String, Integer> map = this.backend.getAPI().getCaseOpenManager().getCache(player.getName());
            int count = map.values().stream().mapToInt(c -> c).sum();
            if (parts.length == 2) {
                return String.valueOf(count);
            }
            if (parts[2].equalsIgnoreCase("format")) {
                return NumberFormat.getNumberInstance().format(count);
            }
            return String.valueOf(count);
        }
        if (params.startsWith("open_count_")) {
            String[] parts = params.split("_", 4);
            int count = this.backend.getAPI().getCaseOpenManager().getCache(parts[2], player.getName());
            if (parts.length == 3) {
                return String.valueOf(count);
            }
            if (parts[3].equalsIgnoreCase("format")) {
                return NumberFormat.getNumberInstance().format(count);
            }
            return String.valueOf(count);
        }
        return null;
    }

    private String processHistory(@NotNull String params) {
        String[] parts = params.split("_");
        if (parts.length >= 3) {
            List<CaseData.History> list;
            String caseType = parts[0];
            int index = this.parseInt(parts[1]);
            if (index >= 0 && (list = this.backend.getAPI().getDatabase().getCache(caseType)).size() > index) {
                String type;
                CaseData.History history = list.get(index);
                switch (type = parts[2].toLowerCase()) {
                    case "player": {
                        return history.playerName();
                    }
                    case "casetype": {
                        return history.caseType();
                    }
                    case "group": {
                        return history.group();
                    }
                    case "action": {
                        return history.action();
                    }
                    case "item": {
                        return history.item();
                    }
                    case "time": {
                        return DCTools.getDateFormat().format(new Date(history.time()));
                    }
                }
            }
        }
        return null;
    }

    private int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

