/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.event.method;

import com.google.common.base.MoreObjects;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.kyori.event.EventBus;
import net.kyori.event.EventSubscriber;
import net.kyori.event.ReifiedEvent;
import net.kyori.event.method.EventExecutor;
import net.kyori.event.method.MethodScanner;
import net.kyori.event.method.MethodSubscriptionAdapter;
import net.kyori.event.method.annotation.DefaultMethodScanner;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleMethodSubscriptionAdapter<E, L>
implements MethodSubscriptionAdapter<L> {
    private final EventBus<E> bus;
    private final EventExecutor.Factory<E, L> factory;
    private final MethodScanner<L> methodScanner;

    public SimpleMethodSubscriptionAdapter(@NonNull EventBus<E> bus, @NonNull EventExecutor.Factory<E, L> factory) {
        this(bus, factory, DefaultMethodScanner.get());
    }

    public SimpleMethodSubscriptionAdapter(@NonNull EventBus<E> bus, @NonNull EventExecutor.Factory<E, L> factory, @NonNull MethodScanner<L> methodScanner) {
        this.bus = bus;
        this.factory = factory;
        this.methodScanner = methodScanner;
    }

    @Override
    public void register(@NonNull L listener) {
        this.findSubscribers(listener, this.bus::register);
    }

    @Override
    public void unregister(@NonNull L listener) {
        this.bus.unregister(h -> h instanceof MethodEventSubscriber && ((MethodEventSubscriber)h).listener() == listener);
    }

    private void findSubscribers(@NonNull L listener, BiConsumer<@NonNull Class<? extends E>, @NonNull EventSubscriber<E>> consumer) {
        for (Method method : listener.getClass().getDeclaredMethods()) {
            EventExecutor<E, L> executor;
            if (!this.methodScanner.shouldRegister(listener, method)) continue;
            if (method.getParameterCount() != 1) {
                throw new SubscriberGenerationException("Unable to create an event subscriber for method '" + method + "'. Method must have only one parameter.");
            }
            Class<?> methodParameterType = method.getParameterTypes()[0];
            if (!this.bus.eventType().isAssignableFrom(methodParameterType)) {
                throw new SubscriberGenerationException("Unable to create an event subscriber for method '" + method + "'. Method parameter type '" + methodParameterType + "' does not extend event type '" + this.bus.eventType() + '\'');
            }
            try {
                executor = this.factory.create(listener, method);
            }
            catch (Exception e) {
                throw new SubscriberGenerationException("Encountered an exception while creating an event subscriber for method '" + method + '\'', e);
            }
            Class<?> eventClass = methodParameterType;
            int postOrder = this.methodScanner.postOrder(listener, method);
            boolean consumeCancelled = this.methodScanner.consumeCancelledEvents(listener, method);
            consumer.accept(eventClass, new MethodEventSubscriber(eventClass, method, executor, listener, postOrder, consumeCancelled));
        }
    }

    private static final class MethodEventSubscriber<E, L>
    implements EventSubscriber<E> {
        private final Class<? extends E> event;
        private final @Nullable Type generic;
        private final EventExecutor<E, L> executor;
        private final L listener;
        private final int postOrder;
        private final boolean includeCancelled;

        MethodEventSubscriber(Class<? extends E> eventClass, @NonNull Method method, @NonNull EventExecutor<E, L> executor, @NonNull L listener, int postOrder, boolean includeCancelled) {
            this.event = eventClass;
            this.generic = ReifiedEvent.class.isAssignableFrom(this.event) ? MethodEventSubscriber.genericType(method.getGenericParameterTypes()[0]) : null;
            this.executor = executor;
            this.listener = listener;
            this.postOrder = postOrder;
            this.includeCancelled = includeCancelled;
        }

        private static @Nullable Type genericType(Type type) {
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getActualTypeArguments()[0];
            }
            return null;
        }

        @NonNull L listener() {
            return this.listener;
        }

        @Override
        public void invoke(@NonNull E event) throws Throwable {
            this.executor.invoke(this.listener, event);
        }

        @Override
        public int postOrder() {
            return this.postOrder;
        }

        @Override
        public boolean consumeCancelledEvents() {
            return this.includeCancelled;
        }

        @Override
        public @Nullable Type genericType() {
            return this.generic;
        }

        public int hashCode() {
            return Objects.hash(this.event, this.generic, this.executor, this.listener, this.postOrder, this.includeCancelled);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof MethodEventSubscriber)) {
                return false;
            }
            MethodEventSubscriber that = (MethodEventSubscriber)other;
            return Objects.equals(this.event, that.event) && Objects.equals(this.generic, that.generic) && Objects.equals(this.executor, that.executor) && Objects.equals(this.listener, that.listener) && Objects.equals(this.postOrder, that.postOrder) && Objects.equals(this.includeCancelled, that.includeCancelled);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("event", this.event).add("generic", (Object)this.generic).add("executor", this.executor).add("listener", this.listener).add("priority", this.postOrder).add("includeCancelled", this.includeCancelled).toString();
        }
    }

    public static final class SubscriberGenerationException
    extends RuntimeException {
        SubscriberGenerationException(String message) {
            super(message);
        }

        SubscriberGenerationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

