/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.addon;

import com.google.common.io.ByteStreams;
import com.jodexindustries.donatecase.api.addon.InternalAddonDescription;
import com.jodexindustries.donatecase.api.addon.InternalJavaAddon;
import com.jodexindustries.donatecase.api.addon.InvalidAddonException;
import com.jodexindustries.donatecase.api.manager.AddonManager;
import com.jodexindustries.donatecase.api.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalAddonClassLoader
extends URLClassLoader {
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final InternalAddonDescription description;
    private final File file;
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    private final AddonManager manager;
    private final InternalJavaAddon addon;
    private final Platform platform;

    public InternalAddonClassLoader(@Nullable ClassLoader parent, InternalAddonDescription description, AddonManager manager, Platform platform) throws IOException, InvalidAddonException, ClassNotFoundException {
        super(new URL[]{description.getFile().toURI().toURL()}, parent);
        this.description = description;
        this.file = description.getFile();
        this.jar = new JarFile(this.file);
        this.manifest = this.jar.getManifest();
        this.url = this.file.toURI().toURL();
        this.manager = manager;
        this.platform = platform;
        try {
            Class<InternalJavaAddon> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMainClass(), true, this);
            }
            catch (ClassNotFoundException ex) {
                throw new ClassNotFoundException("Cannot find main class `" + description.getMainClass() + "'", ex);
            }
            try {
                pluginClass = jarClass.asSubclass(InternalJavaAddon.class);
            }
            catch (ClassCastException ex) {
                throw new ClassCastException("Main class `" + description.getMainClass() + "' does not extend JavaAddon");
            }
            this.addon = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new InvalidAddonException("No public constructor", e);
        }
        catch (InstantiationException ex) {
            throw new InvalidAddonException("Abnormal addon type", ex);
        }
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    synchronized void initialize(@NotNull InternalJavaAddon module) {
        if (module.getClass().getClassLoader() != this) {
            throw new IllegalArgumentException("Cannot initialize module outside of this class loader");
        }
        module.init(this.description, this.file, this, this.platform);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass0(name, resolve, true);
    }

    public Class<?> loadClass0(@NotNull String name, boolean resolve, boolean global) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> result;
            if (global && (result = this.manager.getClassByName(name, resolve)) != null && result.getClassLoader() instanceof InternalAddonClassLoader) {
                return result;
            }
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("org.bukkit.") || name.startsWith("net.minecraft.")) {
            throw new ClassNotFoundException(name);
        }
        Class<?> result = this.classes.get(name);
        if (result == null) {
            String path = name.replace('.', '/').concat(".class");
            JarEntry entry = this.jar.getJarEntry(path);
            if (entry != null) {
                byte[] classBytes;
                block18: {
                    String pkgName;
                    try (InputStream is = this.jar.getInputStream(entry);){
                        classBytes = ByteStreams.toByteArray((InputStream)is);
                    }
                    catch (IOException ex) {
                        throw new ClassNotFoundException(name, ex);
                    }
                    int dot = name.lastIndexOf(46);
                    if (dot != -1 && this.getPackage(pkgName = name.substring(0, dot)) == null) {
                        try {
                            if (this.manifest != null) {
                                this.definePackage(pkgName, this.manifest, this.url);
                            } else {
                                this.definePackage(pkgName, null, null, null, null, null, null, null);
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            if (this.getPackage(pkgName) != null) break block18;
                            throw new IllegalStateException("Cannot find package " + pkgName);
                        }
                    }
                }
                CodeSigner[] signers = entry.getCodeSigners();
                CodeSource source = new CodeSource(this.url, signers);
                result = this.defineClass(name, classBytes, 0, classBytes.length, source);
            }
            if (result == null) {
                result = super.findClass(name);
            }
            this.classes.put(name, result);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.jar.close();
        }
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public InternalJavaAddon getAddon() {
        return this.addon;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

