/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.addon;

import com.jodexindustries.donatecase.api.addon.InternalAddon;
import com.jodexindustries.donatecase.api.addon.InternalAddonClassLoader;
import com.jodexindustries.donatecase.api.addon.InternalAddonDescription;
import com.jodexindustries.donatecase.api.addon.InternalAddonLogger;
import com.jodexindustries.donatecase.api.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InternalJavaAddon
implements InternalAddon {
    private boolean isEnabled = false;
    private ClassLoader classLoader;
    private InternalAddonLogger internalAddonLogger;
    private File file;
    private InternalAddonClassLoader urlClassLoader;
    private InternalAddonDescription description;
    private Platform platform;

    public InternalJavaAddon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!(classLoader instanceof InternalAddonClassLoader)) {
            throw new IllegalArgumentException("InternalJavaAddon requires " + InternalAddonClassLoader.class.getName());
        }
        ((InternalAddonClassLoader)classLoader).initialize(this);
    }

    void init(InternalAddonDescription description, File file, InternalAddonClassLoader loader, Platform platform) {
        this.description = description;
        this.file = file;
        this.classLoader = this.getClass().getClassLoader();
        this.urlClassLoader = loader;
        this.platform = platform;
        this.internalAddonLogger = new InternalAddonLogger(this);
    }

    public final void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            if (this.isEnabled) {
                this.onEnable();
            } else {
                this.onDisable();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onLoad() {
    }

    @Override
    @NotNull
    public final File getDataFolder() {
        File data = new File(this.getPlatform().getDataFolder(), "addons/" + this.getDescription().getName());
        if (!data.exists()) {
            data.mkdirs();
        }
        return data;
    }

    @Override
    public final String getVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    @NotNull
    public final String getName() {
        return this.getDescription().getName();
    }

    @Override
    public final void saveResource(@NotNull String resourcePath, boolean replace) {
        if (resourcePath.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be empty");
        }
        InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in " + this.file);
        }
        File outFile = new File(this.getDataFolder(), resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(this.getDataFolder(), resourcePath.substring(0, Math.max(lastIndex, 0)));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists() || replace) {
                int len;
                OutputStream out = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
                in.close();
            } else {
                this.getLogger().log(Level.WARNING, "Could not save " + outFile.getName() + " to " + outFile + " because " + outFile.getName() + " already exists.");
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + outFile, ex);
        }
    }

    @Override
    @Nullable
    public final InputStream getResource(@NotNull String filename) {
        try {
            URL url = this.getUrlClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    @NotNull
    public final InternalAddonLogger getLogger() {
        return this.internalAddonLogger;
    }

    public final InternalAddonClassLoader getUrlClassLoader() {
        return this.urlClassLoader;
    }

    @Override
    @NotNull
    public final InternalAddonDescription getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }
}

