/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.data.casedefinition;

import com.jodexindustries.donatecase.api.data.casedefinition.CaseMaterial;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.spongepowered.configurate.ConfigurationNode;

public class CaseMenu
implements Cloneable {
    private String id;
    private String title;
    private int size;
    private int updateRate;
    private Map<String, Item> items;

    public CaseMenu(String id, String title, int size, int updateRate, Map<String, Item> items) {
        this.id = id;
        this.title = title;
        this.size = size;
        this.updateRate = updateRate;
        this.items = items;
    }

    public String getItemTypeBySlot(int slot) {
        for (Item item : this.items.values()) {
            if (!item.slots.contains(slot)) continue;
            return item.type;
        }
        return null;
    }

    public CaseMenu clone() {
        try {
            CaseMenu clone = (CaseMenu)super.clone();
            clone.items = this.items.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Item)entry.getValue()).clone(), (a, b) -> b));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Generated
    public String id() {
        return this.id;
    }

    @Generated
    public String title() {
        return this.title;
    }

    @Generated
    public int size() {
        return this.size;
    }

    @Generated
    public int updateRate() {
        return this.updateRate;
    }

    @Generated
    public Map<String, Item> items() {
        return this.items;
    }

    @Generated
    public void id(String id) {
        this.id = id;
    }

    @Generated
    public void title(String title) {
        this.title = title;
    }

    @Generated
    public void size(int size) {
        this.size = size;
    }

    @Generated
    public void updateRate(int updateRate) {
        this.updateRate = updateRate;
    }

    @Generated
    public void items(Map<String, Item> items) {
        this.items = items;
    }

    public static class Item
    implements Cloneable {
        private ConfigurationNode node;
        private String name;
        private String type;
        private CaseMaterial material;
        private List<Integer> slots;

        public Item(ConfigurationNode node, String name, String type, CaseMaterial material, List<Integer> slots) {
            this.node = node;
            this.name = name;
            this.type = type;
            this.material = material;
            this.slots = slots;
        }

        public Item clone() {
            try {
                Item cloned = (Item)super.clone();
                cloned.node = this.node.copy();
                if (cloned.material != null) {
                    cloned.material = this.material.clone();
                }
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        @Generated
        public ConfigurationNode node() {
            return this.node;
        }

        @Generated
        public String name() {
            return this.name;
        }

        @Generated
        public String type() {
            return this.type;
        }

        @Generated
        public CaseMaterial material() {
            return this.material;
        }

        @Generated
        public List<Integer> slots() {
            return this.slots;
        }

        @Generated
        public void node(ConfigurationNode node) {
            this.node = node;
        }

        @Generated
        public void name(String name) {
            this.name = name;
        }

        @Generated
        public void type(String type) {
            this.type = type;
        }

        @Generated
        public void material(CaseMaterial material) {
            this.material = material;
        }

        @Generated
        public void slots(List<Integer> slots) {
            this.slots = slots;
        }
    }
}

