/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.data.database;

import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.config.ConfigData;

public enum DatabaseType {
    MYSQL{

        @Override
        public JdbcConnectionSource build(DCAPI api, ConfigData.Database.Settings settings) throws Exception {
            String url = "jdbc:mysql://" + settings.host() + ":" + settings.port() + "/" + settings.database() + "?autoReconnect=true&useSSL=false&characterEncoding=utf8";
            return new JdbcConnectionSource(url, settings.username(), settings.password());
        }
    }
    ,
    SQLITE{

        @Override
        public JdbcConnectionSource build(DCAPI api, ConfigData.Database.Settings settings) throws Exception {
            String url = "jdbc:sqlite:" + api.getPlatform().getDataFolder().getAbsolutePath() + "/database.db";
            return new JdbcConnectionSource(url);
        }
    }
    ,
    POSTGRESQL{

        @Override
        public JdbcConnectionSource build(DCAPI api, ConfigData.Database.Settings settings) throws Exception {
            String url = "jdbc:postgresql://" + settings.host() + ":" + settings.port() + "/" + settings.database();
            return new JdbcConnectionSource(url, settings.username(), settings.password());
        }
    };


    public abstract JdbcConnectionSource build(DCAPI var1, ConfigData.Database.Settings var2) throws Exception;
}

