/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.manager;

import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.data.action.ActionException;
import com.jodexindustries.donatecase.api.data.action.CaseAction;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ActionManager {
    public void register(CaseAction var1) throws ActionException;

    public void unregister(@NotNull String var1);

    default public void unregister(Addon addon) {
        ArrayList<CaseAction> list = new ArrayList<CaseAction>(this.get(addon));
        list.stream().map(CaseAction::name).forEach(this::unregister);
    }

    public void unregister();

    default public boolean isRegistered(@NotNull String name) {
        return this.getMap().containsKey(name);
    }

    default public Optional<CaseAction> get(@NotNull String name) {
        return Optional.ofNullable(this.getMap().get(name));
    }

    default public List<CaseAction> get(Addon addon) {
        return this.getMap().values().stream().filter(action -> action.addon().equals(addon)).collect(Collectors.toList());
    }

    @NotNull
    public Map<String, CaseAction> getMap();

    default public Optional<String> getByStart(@NotNull String prefix) {
        return this.getMap().keySet().stream().filter(prefix::startsWith).sorted().findFirst();
    }

    public void execute(@Nullable DCPlayer var1, @NotNull String var2, int var3);

    public void execute(@Nullable DCPlayer var1, @NotNull List<String> var2);
}

