/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.manager;

import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.data.subcommand.SubCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SubCommandManager {
    public void register(SubCommand var1);

    public void unregister(String var1);

    default public void unregister(Addon addon) {
        ArrayList<SubCommand> list = new ArrayList<SubCommand>(this.get(addon));
        list.stream().map(SubCommand::name).forEach(this::unregister);
    }

    public void unregister();

    default public boolean isRegistered(@NotNull String name) {
        return this.getMap().containsKey(name);
    }

    @Nullable
    public SubCommand get(String var1);

    default public List<SubCommand> get(Addon addon) {
        return this.getMap().values().stream().filter(subCommand -> subCommand.addon().equals(addon)).collect(Collectors.toList());
    }

    @NotNull
    public Map<String, SubCommand> getMap();
}

